/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.ui.matrix;

import java.util.Objects;
import java.util.Set;
import org.eclipse.capra.ui.matrix.TraceabilityMatrixEntryData;
import org.eclipse.capra.ui.matrix.views.TraceabilityMatrixView;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.nebula.widgets.nattable.ui.NatEventData;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator;

public class QuickFixDynamicMenu
extends ContributionItem {
    public void fill(Menu menu, int index) {
        IMarkerResolution[] resolutions;
        Object natEventDataRaw;
        TraceabilityMatrixView traceMatrixView = TraceabilityMatrixView.getOpenedView();
        TraceabilityMatrixEntryData entryData = null;
        if (menu.getParentMenu() != null && (natEventDataRaw = menu.getParentMenu().getData("natEventData")) != null && natEventDataRaw instanceof NatEventData) {
            NatEventData natEventData = (NatEventData)natEventDataRaw;
            entryData = traceMatrixView.getHeaderEntryDataForTablePositions(natEventData.getColumnPosition(), natEventData.getRowPosition());
        }
        if (Objects.isNull(entryData)) {
            return;
        }
        Set<IMarker> markers = entryData.getMarkers();
        if (Objects.isNull(markers) || markers.size() == 0) {
            MenuItem menuItem = new MenuItem(menu, 8, index);
            menuItem.setEnabled(false);
            menuItem.setText("No quick fixes for current artifact available");
            return;
        }
        IMarkerResolutionGenerator resolutionGenerator = this.getMarkerResolutionGenerator();
        if (Objects.isNull(resolutionGenerator)) {
            return;
        }
        final IMarker marker = markers.iterator().next();
        IMarkerResolution[] iMarkerResolutionArray = resolutions = resolutionGenerator.getResolutions(marker);
        int n = resolutions.length;
        int n2 = 0;
        while (n2 < n) {
            final IMarkerResolution resolution = iMarkerResolutionArray[n2];
            MenuItem menuItem = new MenuItem(menu, 8, index);
            menuItem.setText(resolution.getLabel());
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    resolution.run(marker);
                }
            });
            ++n2;
        }
    }

    private IMarkerResolutionGenerator getMarkerResolutionGenerator() {
        IConfigurationElement[] configs;
        IConfigurationElement[] iConfigurationElementArray = configs = Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.ui.ide.markerResolution");
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement config = iConfigurationElementArray[n2];
            if (config.getAttribute("class").equals("org.eclipse.capra.ui.notification.MarkerResolutionGenerator")) {
                try {
                    return (IMarkerResolutionGenerator)config.createExecutableExtension("class");
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        return null;
    }
}

