/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.handler.office;

import java.io.File;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.NoSuchFileException;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.eclipse.capra.core.adapters.Connection;
import org.eclipse.capra.core.adapters.IArtifactMetaModelAdapter;
import org.eclipse.capra.core.handlers.AbstractArtifactHandler;
import org.eclipse.capra.core.helpers.ExtensionPointHelper;
import org.eclipse.capra.ui.office.Activator;
import org.eclipse.capra.ui.office.model.CapraOfficeObject;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.emf.ecore.EObject;

public class OfficeHandler
extends AbstractArtifactHandler<CapraOfficeObject> {
    public EObject createWrapper(CapraOfficeObject officeObject, EObject artifactModel) {
        IArtifactMetaModelAdapter adapter = (IArtifactMetaModelAdapter)ExtensionPointHelper.getArtifactMetaModelAdapter().orElseThrow();
        return adapter.createArtifact(artifactModel, ((Object)((Object)this)).getClass().getName(), officeObject.getUri().toString(), null, this.getDisplayName(officeObject));
    }

    public CapraOfficeObject resolveWrapper(EObject wrapper) {
        IArtifactMetaModelAdapter adapter = (IArtifactMetaModelAdapter)ExtensionPointHelper.getArtifactMetaModelAdapter().orElseThrow();
        String uri = adapter.getArtifactUri(wrapper);
        CapraOfficeObject object = new CapraOfficeObject();
        object.setUri(uri);
        object.setData(adapter.getArtifactName(wrapper));
        return object;
    }

    public boolean doesArtifactExist(EObject wrapper) {
        try {
            File file = this.resolveWrapper(wrapper).getFile();
        }
        catch (NoSuchFileException ex) {
            return false;
        }
        return true;
    }

    public String getDisplayName(CapraOfficeObject officeObject) {
        StringBuilder displayName = new StringBuilder();
        if (officeObject.getUri().getQuery().contains("sheet")) {
            String sheetName = "";
            String rowId = "";
            List params = URLEncodedUtils.parse((URI)officeObject.getUri(), (Charset)Charset.forName("UTF-8"));
            for (NameValuePair param : params) {
                if (param.getName().equals("sheet")) {
                    sheetName = param.getValue();
                    continue;
                }
                if (!param.getName().equals("row")) continue;
                rowId = param.getValue();
            }
            displayName.append(sheetName);
            displayName.append("!");
            displayName.append(rowId);
            displayName.append(" (");
            displayName.append(Paths.get(officeObject.getUri().getPath(), new String[0]).getFileName().toString());
            displayName.append(")");
        } else {
            int minAllowed = Activator.getDefault().getPreferenceStore().getInt("org.eclipse.capra.ui.office.preferences.charCount");
            String text = officeObject.toString();
            int textLength = Math.min(text.length(), minAllowed);
            if (textLength == minAllowed) {
                text = String.valueOf(text.substring(0, textLength)) + "...";
            }
            text = text.replaceAll("\\R+", " ");
            displayName.append(text);
        }
        return displayName.toString();
    }

    public String generateMarkerMessage(IResourceDelta delta, String wrapperUri) {
        return null;
    }

    public List<Connection> getInternalLinks(EObject investigatedElement, List<String> selectedRelationshipTypes, boolean reverseDirection) {
        return Collections.emptyList();
    }

    public boolean isThereAnInternalTraceBetween(EObject first, EObject second) {
        return false;
    }
}

