/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.generic.metadatamodel.properties;

import org.eclipse.capra.core.adapters.IPersistenceAdapter;
import org.eclipse.capra.core.helpers.EditingDomainHelper;
import org.eclipse.capra.core.helpers.ExtensionPointHelper;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalCommandStack;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.ui.views.properties.IPropertySource;

public abstract class MetadataPropertiesSource
implements IPropertySource {
    protected static final String CATEGORY_NAME = "Metadata";
    protected EObject metadata;

    protected void updateInTransaction(final int featureId, final Object value) {
        TransactionalEditingDomain editingDomain = EditingDomainHelper.getEditingDomain();
        RecordingCommand cmd = new RecordingCommand(editingDomain, "Update Trace Model"){

            protected void doExecute() {
                EStructuralFeature feature = MetadataPropertiesSource.this.metadata.eClass().getEStructuralFeature(featureId);
                if (feature == null) {
                    throw new IllegalArgumentException("Feature not found in metadata.");
                }
                MetadataPropertiesSource.this.metadata.eSet(feature, value);
            }
        };
        try {
            ((TransactionalCommandStack)editingDomain.getCommandStack()).execute((Command)cmd, null);
        }
        catch (RollbackException e) {
            throw new IllegalStateException("Updating trace metadata was rolled back.", e);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("Updating trace metadata was interrupted.", e);
        }
        IPersistenceAdapter persistenceAdapter = (IPersistenceAdapter)ExtensionPointHelper.getPersistenceAdapter().orElseThrow();
        persistenceAdapter.saveModels(EditingDomainHelper.getResourceSet());
    }
}

