/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.capra.generic.metadatamodel.properties;

import java.util.ArrayList;
import java.util.Date;
import org.eclipse.capra.core.adapters.Connection;
import org.eclipse.capra.core.adapters.IMetadataAdapter;
import org.eclipse.capra.core.adapters.IPersistenceAdapter;
import org.eclipse.capra.core.helpers.EditingDomainHelper;
import org.eclipse.capra.core.helpers.ExtensionPointHelper;
import org.eclipse.capra.generic.metadatamodel.TraceMetadata;
import org.eclipse.capra.generic.metadatamodel.impl.TraceMetadataImpl;
import org.eclipse.capra.generic.metadatamodel.properties.MetadataPropertiesSource;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;
import org.eclipse.ui.views.properties.TextPropertyDescriptor;

public class ConnectionMetadataProperties
extends MetadataPropertiesSource {
    public ConnectionMetadataProperties(Connection connection) {
        IMetadataAdapter metadataAdapter = (IMetadataAdapter)ExtensionPointHelper.getTraceMetadataAdapter().orElseThrow();
        IPersistenceAdapter persistenceAdapter = (IPersistenceAdapter)ExtensionPointHelper.getPersistenceAdapter().orElseThrow();
        this.metadata = metadataAdapter.getMetadataForTrace(connection.getTlink(), persistenceAdapter.getMetadataContainer(EditingDomainHelper.getResourceSet()));
    }

    public Object getEditableValue() {
        return this;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        ArrayList<Object> propertyDescriptors = new ArrayList<Object>();
        PropertyDescriptor creationDateDescriptor = new PropertyDescriptor((Object)DescriptorIDs.CREATION_DATE, DescriptorIDs.CREATION_DATE.toString());
        creationDateDescriptor.setCategory("Metadata");
        propertyDescriptors.add(creationDateDescriptor);
        PropertyDescriptor creationUserDescriptor = new PropertyDescriptor((Object)DescriptorIDs.CREATION_USER, DescriptorIDs.CREATION_USER.toString());
        creationUserDescriptor.setCategory("Metadata");
        propertyDescriptors.add(creationUserDescriptor);
        TextPropertyDescriptor commentDescriptor = new TextPropertyDescriptor((Object)DescriptorIDs.COMMENT, DescriptorIDs.COMMENT.toString());
        commentDescriptor.setCategory("Metadata");
        propertyDescriptors.add(commentDescriptor);
        IPropertyDescriptor[] dummyList = new IPropertyDescriptor[propertyDescriptors.size()];
        return propertyDescriptors.toArray(dummyList);
    }

    public Object getPropertyValue(Object id) {
        DescriptorIDs descId = null;
        if (id instanceof DescriptorIDs) {
            descId = (DescriptorIDs)((Object)id);
        } else if (id instanceof String) {
            try {
                descId = DescriptorIDs.fromString((String)id);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (descId != null && descId.equals((Object)DescriptorIDs.CREATION_DATE)) {
            return ((TraceMetadata)this.metadata).getCreationDate();
        }
        if (descId != null && descId.equals((Object)DescriptorIDs.CREATION_USER)) {
            return ((TraceMetadata)this.metadata).getCreationUser();
        }
        if (descId != null && descId.equals((Object)DescriptorIDs.COMMENT)) {
            return ((TraceMetadata)this.metadata).getComment();
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        if (id.equals((Object)DescriptorIDs.CREATION_DATE)) {
            return ((TraceMetadataImpl)this.metadata).eIsSet(0);
        }
        if (id.equals((Object)DescriptorIDs.CREATION_USER)) {
            return ((TraceMetadataImpl)this.metadata).eIsSet(2);
        }
        if (id.equals((Object)DescriptorIDs.COMMENT)) {
            return ((TraceMetadataImpl)this.metadata).eIsSet(1);
        }
        return false;
    }

    public void resetPropertyValue(Object id) {
        if (id.equals((Object)DescriptorIDs.CREATION_DATE)) {
            ((TraceMetadataImpl)this.metadata).eUnset(0);
        } else if (id.equals((Object)DescriptorIDs.CREATION_USER)) {
            ((TraceMetadataImpl)this.metadata).eUnset(2);
        } else if (id.equals((Object)DescriptorIDs.COMMENT)) {
            ((TraceMetadataImpl)this.metadata).eUnset(1);
        }
    }

    public void setPropertyValue(Object id, Object value) {
        if (id.equals((Object)DescriptorIDs.CREATION_DATE) && value instanceof Date) {
            this.updateInTransaction(0, value);
        } else if (id.equals((Object)DescriptorIDs.CREATION_USER) && value instanceof String) {
            this.updateInTransaction(2, value);
        } else if (id.equals((Object)DescriptorIDs.COMMENT) && value instanceof String) {
            this.updateInTransaction(1, value);
        }
    }

    private static enum DescriptorIDs {
        CREATION_DATE("Creation Date"),
        CREATION_USER("Creation User"),
        COMMENT("Comment");

        private final String name;

        private DescriptorIDs(String s) {
            this.name = s;
        }

        public String toString() {
            return this.name;
        }

        public static DescriptorIDs fromString(String value) {
            if (value == null) {
                throw new IllegalArgumentException("Provided value must not be null");
            }
            DescriptorIDs[] descriptorIDsArray = DescriptorIDs.values();
            int n = descriptorIDsArray.length;
            int n2 = 0;
            while (n2 < n) {
                DescriptorIDs descId = descriptorIDsArray[n2];
                if (descId.toString().equals(value)) {
                    return descId;
                }
                ++n2;
            }
            throw new IllegalArgumentException("Provided value does not correspond to any enum value");
        }
    }
}

