/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.xmlpivot.common;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.ModellingcorePackage;
import org.polarsys.capella.core.data.capellacommon.CapellacommonPackage;
import org.polarsys.capella.core.data.capellacore.CapellacorePackage;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.ctx.CtxPackage;
import org.polarsys.capella.core.data.epbs.EpbsPackage;
import org.polarsys.capella.core.data.fa.FaPackage;
import org.polarsys.capella.core.data.information.InformationPackage;
import org.polarsys.capella.core.data.information.datatype.DatatypePackage;
import org.polarsys.capella.core.data.information.datavalue.DatavaluePackage;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.oa.OaPackage;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.data.pa.deployment.DeploymentPackage;
import org.polarsys.capella.core.data.requirement.RequirementPackage;
import org.polarsys.capella.core.model.semantic.AbstractMetaData;
import org.polarsys.capella.xmlpivot.common.CapellaDerivedFeatureMetadata;

public class BasicCapellaDerivedFeatureMetaData
implements CapellaDerivedFeatureMetadata {
    private final AbstractMetaData derivedMetaData;
    private final AbstractMetaData associationClassMetaData;

    public BasicCapellaDerivedFeatureMetaData(Map<EModelElement, EAnnotation> mapping_p) {
        this.derivedMetaData = new AbstractMetaData("http://www.polarsys.org/capella/semantic/derivedFeature", mapping_p);
        this.associationClassMetaData = new AbstractMetaData("http://www.polarsys.org/capella/semantic/associationClass", mapping_p);
        this.setHoldingFeature((EStructuralFeature)CapellacorePackage.Literals.TYPED_ELEMENT__TYPE, (EStructuralFeature)ModellingcorePackage.Literals.ABSTRACT_TYPED_ELEMENT__ABSTRACT_TYPE);
        this.setHoldingFeature((EStructuralFeature)DatavaluePackage.Literals.ABSTRACT_ENUMERATION_VALUE__ENUMERATION_TYPE, (EStructuralFeature)ModellingcorePackage.Literals.ABSTRACT_TYPED_ELEMENT__ABSTRACT_TYPE);
        this.setHoldingFeature((EStructuralFeature)DatavaluePackage.Literals.NUMERIC_VALUE__NUMERIC_TYPE, (EStructuralFeature)ModellingcorePackage.Literals.ABSTRACT_TYPED_ELEMENT__ABSTRACT_TYPE);
        this.setHoldingFeature((EStructuralFeature)DatavaluePackage.Literals.ABSTRACT_BOOLEAN_VALUE__BOOLEAN_TYPE, (EStructuralFeature)ModellingcorePackage.Literals.ABSTRACT_TYPED_ELEMENT__ABSTRACT_TYPE);
        this.setHoldingFeature((EStructuralFeature)DatavaluePackage.Literals.ABSTRACT_STRING_VALUE__STRING_TYPE, (EStructuralFeature)ModellingcorePackage.Literals.ABSTRACT_TYPED_ELEMENT__ABSTRACT_TYPE);
        this.setAssociationClass(OaPackage.Literals.ENTITY__ALLOCATED_OPERATIONAL_ACTIVITIES, FaPackage.Literals.COMPONENT_FUNCTIONAL_ALLOCATION);
        this.setAssociationClass(OaPackage.Literals.ENTITY__ALLOCATED_ROLES, OaPackage.Literals.ROLE_ALLOCATION);
        this.setAssociationClass(OaPackage.Literals.ROLE__ALLOCATED_OPERATIONAL_ACTIVITIES, OaPackage.Literals.ACTIVITY_ALLOCATION);
        this.setAssociationClass(OaPackage.Literals.OPERATIONAL_CAPABILITY__INVOLVED_ENTITIES, OaPackage.Literals.ENTITY_OPERATIONAL_CAPABILITY_INVOLVEMENT);
        this.setHoldingFeature((EStructuralFeature)OaPackage.Literals.COMMUNICATION_MEAN__SOURCE_ENTITY, (EStructuralFeature)ModellingcorePackage.Literals.ABSTRACT_INFORMATION_FLOW__SOURCE);
        this.setHoldingFeature((EStructuralFeature)OaPackage.Literals.COMMUNICATION_MEAN__TARGET_ENTITY, (EStructuralFeature)ModellingcorePackage.Literals.ABSTRACT_INFORMATION_FLOW__TARGET);
        this.setHoldingFeature((EStructuralFeature)RequirementPackage.Literals.REQUIREMENTS_TRACE__SOURCE, (EStructuralFeature)ModellingcorePackage.Literals.ABSTRACT_TRACE__SOURCE_ELEMENT);
        this.setHoldingFeature((EStructuralFeature)RequirementPackage.Literals.REQUIREMENTS_TRACE__TARGET, (EStructuralFeature)ModellingcorePackage.Literals.ABSTRACT_TRACE__TARGET_ELEMENT);
        this.defineAssociationClass(ModellingcorePackage.Literals.ABSTRACT_TRACE__SOURCE_ELEMENT, ModellingcorePackage.Literals.ABSTRACT_TRACE__TARGET_ELEMENT);
        this.defineAssociationClass(CapellacorePackage.Literals.INVOLVEMENT__INVOLVER, CapellacorePackage.Literals.INVOLVEMENT__INVOLVED);
        this.defineAssociationClass(CapellacorePackage.Literals.GENERALIZATION__SUB, CapellacorePackage.Literals.GENERALIZATION__SUPER);
        this.defineAssociationClass(CtxPackage.Literals.CAPABILITY_EXPLOITATION__MISSION, CtxPackage.Literals.CAPABILITY_EXPLOITATION__CAPABILITY);
        this.defineAssociationClass(CsPackage.Literals.ABSTRACT_DEPLOYMENT_LINK__LOCATION, CsPackage.Literals.ABSTRACT_DEPLOYMENT_LINK__DEPLOYED_ELEMENT);
        this.setAssociationClass(FaPackage.Literals.FUNCTIONAL_EXCHANGE__REALIZED_FUNCTIONAL_EXCHANGES, FaPackage.Literals.FUNCTIONAL_EXCHANGE_REALIZATION);
        this.setAssociationClass(FaPackage.Literals.COMPONENT_PORT__ALLOCATED_FUNCTION_PORTS, InformationPackage.Literals.PORT_ALLOCATION);
        this.setAssociationClass(FaPackage.Literals.COMPONENT_PORT__REALIZED_COMPONENT_PORTS, InformationPackage.Literals.PORT_REALIZATION);
        this.setAssociationClass(FaPackage.Literals.FUNCTION_PORT__REALIZED_FUNCTION_PORTS, InformationPackage.Literals.PORT_REALIZATION);
        this.setAssociationClass(CsPackage.Literals.PHYSICAL_PORT__REALIZED_PHYSICAL_PORTS, InformationPackage.Literals.PORT_REALIZATION);
        this.setAssociationClass(CsPackage.Literals.COMPONENT__USED_INTERFACES, CsPackage.Literals.INTERFACE_USE);
        this.setAssociationClass(CsPackage.Literals.COMPONENT__IMPLEMENTED_INTERFACES, CsPackage.Literals.INTERFACE_IMPLEMENTATION);
        this.setAssociationClass(CsPackage.Literals.PHYSICAL_PATH__REALIZED_PHYSICAL_PATHS, CsPackage.Literals.PHYSICAL_PATH_REALIZATION);
        this.setAssociationClass(CsPackage.Literals.PHYSICAL_LINK__REALIZED_PHYSICAL_LINKS, CsPackage.Literals.PHYSICAL_LINK_REALIZATION);
        this.setAssociationClass(CsPackage.Literals.INTERFACE__REALIZED_LOGICAL_INTERFACES, PaPackage.Literals.LOGICAL_INTERFACE_REALIZATION);
        this.setAssociationClass(CsPackage.Literals.INTERFACE__REALIZED_CONTEXT_INTERFACES, LaPackage.Literals.CONTEXT_INTERFACE_REALIZATION);
        this.setAssociationClass(FaPackage.Literals.FUNCTIONAL_CHAIN__REALIZED_FUNCTIONAL_CHAINS, FaPackage.Literals.FUNCTIONAL_CHAIN_REALIZATION);
        this.setHoldingFeature((EStructuralFeature)FaPackage.Literals.FUNCTIONAL_CHAIN_INVOLVEMENT__INVOLVED_ELEMENT, (EStructuralFeature)CapellacorePackage.Literals.INVOLVEMENT__INVOLVED);
        this.setAssociationClass(FaPackage.Literals.COMPONENT_EXCHANGE__ALLOCATED_FUNCTIONAL_EXCHANGES, FaPackage.Literals.COMPONENT_EXCHANGE_FUNCTIONAL_EXCHANGE_ALLOCATION);
        this.setAssociationClass(FaPackage.Literals.COMPONENT_EXCHANGE__REALIZED_COMPONENT_EXCHANGES, FaPackage.Literals.COMPONENT_EXCHANGE_REALIZATION);
        this.setAssociationClass(FaPackage.Literals.COMPONENT_EXCHANGE_ALLOCATOR__ALLOCATED_COMPONENT_EXCHANGES, FaPackage.Literals.COMPONENT_EXCHANGE_ALLOCATION);
        this.setAssociationClass(CapellacorePackage.Literals.GENERALIZABLE_ELEMENT__SUPER, CapellacorePackage.Literals.GENERALIZATION);
        this.setAssociationClass(InformationPackage.Literals.CLASS__REALIZED_CLASSES, InformationPackage.Literals.INFORMATION_REALIZATION);
        this.setAssociationClass(InformationPackage.Literals.EXCHANGE_ITEM__REALIZED_EXCHANGE_ITEMS, InformationPackage.Literals.INFORMATION_REALIZATION);
        this.setAssociationClass(DatatypePackage.Literals.DATA_TYPE__REALIZED_DATA_TYPES, InformationPackage.Literals.INFORMATION_REALIZATION);
        this.setAssociationClass(InteractionPackage.Literals.ABSTRACT_CAPABILITY__INVOLVED_ABSTRACT_FUNCTIONS, InteractionPackage.Literals.ABSTRACT_FUNCTION_ABSTRACT_CAPABILITY_INVOLVEMENT);
        this.setAssociationClass(InteractionPackage.Literals.ABSTRACT_CAPABILITY__INVOLVED_FUNCTIONAL_CHAINS, InteractionPackage.Literals.FUNCTIONAL_CHAIN_ABSTRACT_CAPABILITY_INVOLVEMENT);
        this.setAssociationClass(InteractionPackage.Literals.ABSTRACT_CAPABILITY__SUPER, InteractionPackage.Literals.ABSTRACT_CAPABILITY_GENERALIZATION);
        this.setAssociationClass(InteractionPackage.Literals.ABSTRACT_CAPABILITY__INCLUDED_ABSTRACT_CAPABILITIES, InteractionPackage.Literals.ABSTRACT_CAPABILITY_INCLUDE);
        this.setAssociationClass(InteractionPackage.Literals.ABSTRACT_CAPABILITY__EXTENDED_ABSTRACT_CAPABILITIES, InteractionPackage.Literals.ABSTRACT_CAPABILITY_EXTEND);
        this.setAssociationClass(InteractionPackage.Literals.SCENARIO__REALIZED_SCENARIOS, InteractionPackage.Literals.SCENARIO_REALIZATION);
        this.setAssociationClass(CtxPackage.Literals.SYSTEM_ANALYSIS__ALLOCATED_OPERATIONAL_ANALYSES, CtxPackage.Literals.OPERATIONAL_ANALYSIS_REALIZATION);
        this.setAssociationClass(CtxPackage.Literals.SYSTEM_FUNCTION__REALIZED_OPERATIONAL_ACTIVITIES, FaPackage.Literals.FUNCTION_REALIZATION);
        this.setAssociationClass(CtxPackage.Literals.SYSTEM__ALLOCATED_SYSTEM_FUNCTIONS, FaPackage.Literals.COMPONENT_FUNCTIONAL_ALLOCATION);
        this.setAssociationClass(CtxPackage.Literals.ACTOR__ALLOCATED_SYSTEM_FUNCTIONS, FaPackage.Literals.COMPONENT_FUNCTIONAL_ALLOCATION);
        this.setAssociationClass(CtxPackage.Literals.SYSTEM__REALIZED_ENTITIES, CtxPackage.Literals.OPERATIONAL_ENTITY_REALIZATION);
        this.setAssociationClass(CtxPackage.Literals.ACTOR__REALIZED_OPERATIONAL_ACTORS, CtxPackage.Literals.OPERATIONAL_ACTOR_REALIZATION);
        this.setAssociationClass(CtxPackage.Literals.ACTOR__REALIZED_ENTITIES, CtxPackage.Literals.OPERATIONAL_ENTITY_REALIZATION);
        this.setAssociationClass(CtxPackage.Literals.MISSION__EXPLOITED_CAPABILITIES, CtxPackage.Literals.CAPABILITY_EXPLOITATION);
        this.setAssociationClass(CtxPackage.Literals.MISSION__PARTICIPATING_ACTORS, CtxPackage.Literals.ACTOR_MISSION_INVOLVEMENT);
        this.setAssociationClass(CtxPackage.Literals.MISSION__PARTICIPATING_SYSTEM, CtxPackage.Literals.SYSTEM_MISSION_INVOLVEMENT);
        this.setAssociationClass(CtxPackage.Literals.CAPABILITY__PARTICIPATING_ACTORS, CtxPackage.Literals.ACTOR_CAPABILITY_INVOLVEMENT);
        this.setAssociationClass(CtxPackage.Literals.CAPABILITY__PARTICIPATING_SYSTEM, CtxPackage.Literals.SYSTEM_CAPABILITY_INVOLVEMENT);
        this.setAssociationClass(CtxPackage.Literals.CAPABILITY__REALIZED_OPERATIONAL_CAPABILITIES, InteractionPackage.Literals.ABSTRACT_CAPABILITY_REALIZATION);
        this.setAssociationClass(CsPackage.Literals.PART__DEPLOYED_PARTS, DeploymentPackage.Literals.PART_DEPLOYMENT_LINK);
        this.setAssociationClass(CsPackage.Literals.PHYSICAL_PORT__ALLOCATED_COMPONENT_PORTS, FaPackage.Literals.COMPONENT_PORT_ALLOCATION);
        this.setAssociationClass(CsPackage.Literals.PHYSICAL_PORT__REALIZED_PHYSICAL_PORTS, CsPackage.Literals.PHYSICAL_PORT_REALIZATION);
        this.setAssociationClass(LaPackage.Literals.LOGICAL_COMPONENT__ALLOCATED_LOGICAL_FUNCTIONS, FaPackage.Literals.COMPONENT_FUNCTIONAL_ALLOCATION);
        this.setAssociationClass(LaPackage.Literals.LOGICAL_ARCHITECTURE__ALLOCATED_SYSTEM_ANALYSES, LaPackage.Literals.SYSTEM_ANALYSIS_REALIZATION);
        this.setAssociationClass(LaPackage.Literals.CAPABILITY_REALIZATION__PARTICIPATING_SYSTEM_COMPONENTS, CsPackage.Literals.SYSTEM_COMPONENT_CAPABILITY_REALIZATION_INVOLVEMENT);
        this.setAssociationClass(LaPackage.Literals.CAPABILITY_REALIZATION__PARTICIPATING_ACTORS, CsPackage.Literals.ACTOR_CAPABILITY_REALIZATION_INVOLVEMENT);
        this.setAssociationClass(LaPackage.Literals.LOGICAL_ACTOR__REALIZED_SYSTEM_ACTORS, LaPackage.Literals.SYSTEM_ACTOR_REALIZATION);
        this.setAssociationClass(LaPackage.Literals.LOGICAL_ACTOR__ALLOCATED_LOGICAL_FUNCTIONS, FaPackage.Literals.COMPONENT_FUNCTIONAL_ALLOCATION);
        this.setAssociationClass(LaPackage.Literals.LOGICAL_COMPONENT__REALIZED_SYSTEMS, LaPackage.Literals.SYSTEM_REALIZATION);
        this.setAssociationClass(LaPackage.Literals.LOGICAL_FUNCTION__REALIZED_SYSTEM_FUNCTIONS, FaPackage.Literals.FUNCTION_REALIZATION);
        this.setAssociationClass(LaPackage.Literals.CAPABILITY_REALIZATION__REALIZED_CAPABILITIES, InteractionPackage.Literals.ABSTRACT_CAPABILITY_REALIZATION);
        this.setAssociationClass(LaPackage.Literals.CAPABILITY_REALIZATION__REALIZED_CAPABILITY_REALIZATIONS, InteractionPackage.Literals.ABSTRACT_CAPABILITY_REALIZATION);
        this.setAssociationClass(PaPackage.Literals.PHYSICAL_COMPONENT__REALIZED_LOGICAL_COMPONENTS, PaPackage.Literals.LOGICAL_COMPONENT_REALIZATION);
        this.setAssociationClass(PaPackage.Literals.PHYSICAL_ACTOR__REALIZED_LOGICAL_ACTORS, PaPackage.Literals.LOGICAL_ACTOR_REALIZATION);
        this.setAssociationClass(PaPackage.Literals.PHYSICAL_COMPONENT__ALLOCATED_PHYSICAL_FUNCTIONS, FaPackage.Literals.COMPONENT_FUNCTIONAL_ALLOCATION);
        this.setAssociationClass(PaPackage.Literals.PHYSICAL_FUNCTION__REALIZED_LOGICAL_FUNCTIONS, FaPackage.Literals.FUNCTION_REALIZATION);
        this.setAssociationClass(PaPackage.Literals.PHYSICAL_ARCHITECTURE__ALLOCATED_LOGICAL_ARCHITECTURES, PaPackage.Literals.LOGICAL_ARCHITECTURE_REALIZATION);
        this.setAssociationClass(PaPackage.Literals.PHYSICAL_ACTOR__ALLOCATED_PHYSICAL_FUNCTIONS, FaPackage.Literals.COMPONENT_FUNCTIONAL_ALLOCATION);
        this.setAssociationClass(EpbsPackage.Literals.EPBS_ARCHITECTURE__ALLOCATED_PHYSICAL_ARCHITECTURES, EpbsPackage.Literals.PHYSICAL_ARCHITECTURE_REALIZATION);
        this.setAssociationClass(EpbsPackage.Literals.CONFIGURATION_ITEM__ALLOCATED_PHYSICAL_ARTIFACTS, EpbsPackage.Literals.PHYSICAL_ARTIFACT_REALIZATION);
        this.setAssociationClass(CapellacommonPackage.Literals.STATE_TRANSITION__REALIZED_STATE_TRANSITIONS, CapellacommonPackage.Literals.STATE_TRANSITION_REALIZATION);
        this.setAssociationClass(CapellacommonPackage.Literals.ABSTRACT_STATE__REALIZED_ABSTRACT_STATES, CapellacommonPackage.Literals.ABSTRACT_STATE_REALIZATION);
    }

    @Override
    public void defineAssociationClass(EReference left, EReference right) {
        EClass c2;
        EClass c1 = left.getEContainingClass();
        if (c1 != (c2 = right.getEContainingClass())) {
            throw new IllegalArgumentException("Both features must be defined on the same class");
        }
        EAnnotation annotation = this.associationClassMetaData.getAnnotation((EModelElement)c1, true);
        annotation.getReferences().add((Object)left);
        annotation.getReferences().add((Object)right);
    }

    @Override
    public EReference getLeft(EClass associationClass) {
        return this.getReference(associationClass, 0);
    }

    @Override
    public EReference getRight(EClass associationClass) {
        return this.getReference(associationClass, 1);
    }

    private EReference getReference(EClass associationClass, int index) {
        ArrayDeque<EClass> deque = new ArrayDeque<EClass>(Collections.singleton(associationClass));
        while (!deque.isEmpty()) {
            EClass top = (EClass)deque.removeFirst();
            EAnnotation annotation = this.associationClassMetaData.getAnnotation((EModelElement)top, false);
            if (annotation != null) {
                return (EReference)annotation.getReferences().get(index);
            }
            deque.addAll((Collection<EClass>)top.getEAllSuperTypes());
        }
        throw new IllegalArgumentException("Not an association class: " + associationClass.getName());
    }

    public BasicCapellaDerivedFeatureMetaData() {
        this(null);
    }

    @Override
    public EClass getAssociationClass(EReference reference_p) {
        EAnnotation ann = this.derivedMetaData.getAnnotation((EModelElement)reference_p, false);
        if (ann != null && ann.getReferences().size() == 1 && ann.getReferences().get(0) instanceof EClass) {
            return (EClass)ann.getReferences().get(0);
        }
        return null;
    }

    @Override
    public void setAssociationClass(EReference reference_p, EClass associationClass_p) {
        EAnnotation ann = this.derivedMetaData.getAnnotation((EModelElement)reference_p, true);
        ann.getReferences().clear();
        ann.getReferences().add((Object)associationClass_p);
    }

    @Override
    public EStructuralFeature getHoldingFeature(EStructuralFeature feature_p) {
        String containmentValue;
        EAnnotation ann = this.derivedMetaData.getAnnotation((EModelElement)feature_p, false);
        if (ann != null && ann.getReferences().size() == 1 && ann.getReferences().get(0) instanceof EStructuralFeature) {
            return (EStructuralFeature)ann.getReferences().get(0);
        }
        ann = feature_p.getEAnnotation("http://www.polarsys.org/capella/semantic");
        if (ann != null && (containmentValue = (String)ann.getDetails().get((Object)"feature")) != null) {
            return feature_p.getEContainingClass().getEStructuralFeature(containmentValue);
        }
        return null;
    }

    @Override
    public void setHoldingFeature(EStructuralFeature feature_p, EStructuralFeature holdingFeature_p) {
        EAnnotation ann = this.derivedMetaData.getAnnotation((EModelElement)feature_p, true);
        ann.getReferences().clear();
        ann.getReferences().add((Object)holdingFeature_p);
    }
}

