/**
 ********************************************************************************
 * Copyright (c) 2018-2020 Robert Bosch GmbH.
 * 
 * This program and the accompanying materials are made
 * available under the terms of the Eclipse Public License 2.0
 * which is available at https://www.eclipse.org/legal/epl-2.0/
 * 
 * SPDX-License-Identifier: EPL-2.0
 * 
 * Contributors:
 *     Robert Bosch GmbH - initial API and implementation
*******************************************************************************/

package org.eclipse.app4mc.amalthea.visualization.hw;

public class ModelToTextResult {
	
	private boolean errorFlag;
	private String errorMessage;
	
	private CharSequence output;

	public ModelToTextResult() {
		this.errorFlag = false;
	}

	public boolean getErrorFlag() {
		return this.errorFlag;
	}

	public void setErrorFlag(boolean errorFlag) {
		this.errorFlag = errorFlag;
	}

	public boolean error() {
		return this.errorFlag;
	}

	public boolean success() {
		return !this.errorFlag;
	}

	public String getErrorMessage() {
		return this.errorMessage;
	}

	public void setErrorMessage(String errorMessage) {
		this.errorMessage = errorMessage;
	}

	public CharSequence getOutput() {
		return output;
	}

	public void setOutput(CharSequence output) {
		this.output = output;
	}
}
