/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.app4mc.amalthea.model.edit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.app4mc.amalthea.model.AmaltheaPackage;
import org.eclipse.app4mc.amalthea.model.CommonElements;
import org.eclipse.app4mc.amalthea.model.edit.common.container.CoreClassifiersContainerIP;
import org.eclipse.app4mc.amalthea.model.edit.common.container.MemoryClassifiersContainerIP;
import org.eclipse.app4mc.amalthea.model.edit.common.container.NamespacesContainerIP;
import org.eclipse.app4mc.amalthea.model.edit.common.container.TagsContainerIP;
import org.eclipse.app4mc.amalthea.model.provider.CommonElementsItemProvider;
import org.eclipse.app4mc.amalthea.model.provider.TransientItemProvider;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ViewerNotification;

public class ExtendedCommonElementsIP
extends CommonElementsItemProvider {
    private static final Set<EStructuralFeature> SPECIAL_FEATURES = new HashSet<EReference>(Arrays.asList(AmaltheaPackage.eINSTANCE.getCommonElements_CoreClassifiers(), AmaltheaPackage.eINSTANCE.getCommonElements_MemoryClassifiers(), AmaltheaPackage.eINSTANCE.getCommonElements_Tags(), AmaltheaPackage.eINSTANCE.getCommonElements_Namespaces()));
    private static final Set<Integer> SPECIAL_FEATURE_IDS = SPECIAL_FEATURES.stream().mapToInt(EStructuralFeature::getFeatureID).boxed().collect(Collectors.toCollection(HashSet::new));
    protected CoreClassifiersContainerIP coreClassifiersCIP;
    protected MemoryClassifiersContainerIP memoryClassifiersCIP;
    protected TagsContainerIP tagsCIP;
    protected NamespacesContainerIP namespacesCIP;

    public ExtendedCommonElementsIP(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public CoreClassifiersContainerIP getCoreClassifiersContainerIP(CommonElements owner) {
        if (this.coreClassifiersCIP == null) {
            this.coreClassifiersCIP = new CoreClassifiersContainerIP(this.adapterFactory, owner);
        }
        return this.coreClassifiersCIP;
    }

    public MemoryClassifiersContainerIP getMemoryClassifiersContainerIP(CommonElements owner) {
        if (this.memoryClassifiersCIP == null) {
            this.memoryClassifiersCIP = new MemoryClassifiersContainerIP(this.adapterFactory, owner);
        }
        return this.memoryClassifiersCIP;
    }

    public TagsContainerIP getTagsContainerIP(CommonElements owner) {
        if (this.tagsCIP == null) {
            this.tagsCIP = new TagsContainerIP(this.adapterFactory, owner);
        }
        return this.tagsCIP;
    }

    public NamespacesContainerIP getNamespacesContainerIP(CommonElements owner) {
        if (this.namespacesCIP == null) {
            this.namespacesCIP = new NamespacesContainerIP(this.adapterFactory, owner);
        }
        return this.namespacesCIP;
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        for (EStructuralFeature feature : super.getChildrenFeatures(object)) {
            if (!this.isValidValue(object, child, feature)) continue;
            return feature;
        }
        return null;
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        HashSet result = new HashSet(super.getChildrenFeatures(object));
        result.removeAll(SPECIAL_FEATURES);
        return result;
    }

    public Collection<?> getChildren(Object object) {
        ArrayList<TransientItemProvider> children = new ArrayList<TransientItemProvider>(super.getChildren(object));
        CommonElements commonElements = (CommonElements)object;
        if (!commonElements.getCoreClassifiers().isEmpty()) {
            children.add(this.getCoreClassifiersContainerIP(commonElements));
        }
        if (!commonElements.getMemoryClassifiers().isEmpty()) {
            children.add(this.getMemoryClassifiersContainerIP(commonElements));
        }
        if (!commonElements.getTags().isEmpty()) {
            children.add(this.getTagsContainerIP(commonElements));
        }
        if (!commonElements.getNamespaces().isEmpty()) {
            children.add(this.getNamespacesContainerIP(commonElements));
        }
        return children;
    }

    protected Command createAddCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Collection<?> collection, int index) {
        return this.createWrappedCommand(super.createAddCommand(domain, owner, feature, collection, index), owner, feature);
    }

    protected Command createRemoveCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Collection<?> collection) {
        return this.createWrappedCommand(super.createRemoveCommand(domain, owner, feature, collection), owner, feature);
    }

    protected Command createWrappedCommand(Command command, final EObject owner, EStructuralFeature feature) {
        final int featureID = feature.getFeatureID();
        if (!SPECIAL_FEATURE_IDS.contains(featureID)) {
            return command;
        }
        return new CommandWrapper(command){

            public Collection<?> getAffectedObjects() {
                Set<TransientItemProvider> affected = super.getAffectedObjects();
                if (affected.contains(owner)) {
                    if (featureID == 3) {
                        affected = Collections.singleton(ExtendedCommonElementsIP.this.getCoreClassifiersContainerIP((CommonElements)owner));
                    } else if (featureID == 4) {
                        affected = Collections.singleton(ExtendedCommonElementsIP.this.getMemoryClassifiersContainerIP((CommonElements)owner));
                    } else if (featureID == 1) {
                        affected = Collections.singleton(ExtendedCommonElementsIP.this.getTagsContainerIP((CommonElements)owner));
                    } else if (featureID == 2) {
                        affected = Collections.singleton(ExtendedCommonElementsIP.this.getNamespacesContainerIP((CommonElements)owner));
                    }
                }
                return affected;
            }
        };
    }

    public void dispose() {
        if (this.coreClassifiersCIP != null) {
            this.coreClassifiersCIP.dispose();
        }
        if (this.memoryClassifiersCIP != null) {
            this.memoryClassifiersCIP.dispose();
        }
        if (this.tagsCIP != null) {
            this.tagsCIP.dispose();
        }
        if (this.namespacesCIP != null) {
            this.namespacesCIP.dispose();
        }
        super.dispose();
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        int featureID = notification.getFeatureID(CommonElements.class);
        if (SPECIAL_FEATURE_IDS.contains(featureID)) {
            this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, true));
        } else {
            super.notifyChanged(notification);
        }
    }
}

