/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.command;

import java.util.Collection;
import org.eclipse.nebula.widgets.nattable.coordinate.ColumnPositionCoordinate;
import org.eclipse.nebula.widgets.nattable.coordinate.PositionCoordinate;
import org.eclipse.nebula.widgets.nattable.coordinate.RowPositionCoordinate;
import org.eclipse.nebula.widgets.nattable.layer.ILayer;

public class LayerCommandUtil {
    private LayerCommandUtil() {
    }

    public static PositionCoordinate convertPositionToTargetContext(PositionCoordinate positionCoordinate, ILayer targetLayer) {
        return LayerCommandUtil.convertPositionToTargetContext(positionCoordinate, targetLayer, false);
    }

    public static PositionCoordinate convertPositionToTargetContext(PositionCoordinate positionCoordinate, ILayer targetLayer, boolean acceptNegativePosition) {
        ILayer layer = positionCoordinate.getLayer();
        if (layer == targetLayer) {
            return positionCoordinate;
        }
        int columnPosition = positionCoordinate.getColumnPosition();
        int underlyingColumnPosition = layer.localToUnderlyingColumnPosition(columnPosition);
        if (!acceptNegativePosition && underlyingColumnPosition < 0) {
            return null;
        }
        int rowPosition = positionCoordinate.getRowPosition();
        int underlyingRowPosition = layer.localToUnderlyingRowPosition(rowPosition);
        if (!acceptNegativePosition && underlyingRowPosition < 0) {
            return null;
        }
        ILayer underlyingLayer = layer.getUnderlyingLayerByPosition(columnPosition, rowPosition);
        if (underlyingLayer == null) {
            return null;
        }
        return LayerCommandUtil.convertPositionToTargetContext(new PositionCoordinate(underlyingLayer, underlyingColumnPosition, underlyingRowPosition), targetLayer, acceptNegativePosition);
    }

    public static ColumnPositionCoordinate convertColumnPositionToTargetContext(ColumnPositionCoordinate columnPositionCoordinate, ILayer targetLayer) {
        return LayerCommandUtil.convertColumnPositionToTargetContext(columnPositionCoordinate, targetLayer, false);
    }

    public static ColumnPositionCoordinate convertColumnPositionToTargetContext(ColumnPositionCoordinate columnPositionCoordinate, ILayer targetLayer, boolean acceptNegativePosition) {
        if (columnPositionCoordinate != null) {
            ILayer layer = columnPositionCoordinate.getLayer();
            if (layer == targetLayer) {
                return columnPositionCoordinate;
            }
            int columnPosition = columnPositionCoordinate.getColumnPosition();
            int underlyingColumnPosition = layer.localToUnderlyingColumnPosition(columnPosition);
            if (!acceptNegativePosition && underlyingColumnPosition < 0) {
                return null;
            }
            Collection<ILayer> underlyingLayers = layer.getUnderlyingLayersByColumnPosition(columnPosition);
            if (underlyingLayers != null) {
                for (ILayer underlyingLayer : underlyingLayers) {
                    ColumnPositionCoordinate convertedColumnPositionCoordinate;
                    if (underlyingLayer == null || (convertedColumnPositionCoordinate = LayerCommandUtil.convertColumnPositionToTargetContext(new ColumnPositionCoordinate(underlyingLayer, underlyingColumnPosition), targetLayer, acceptNegativePosition)) == null) continue;
                    return convertedColumnPositionCoordinate;
                }
            }
        }
        return null;
    }

    public static RowPositionCoordinate convertRowPositionToTargetContext(RowPositionCoordinate rowPositionCoordinate, ILayer targetLayer) {
        return LayerCommandUtil.convertRowPositionToTargetContext(rowPositionCoordinate, targetLayer, false);
    }

    public static RowPositionCoordinate convertRowPositionToTargetContext(RowPositionCoordinate rowPositionCoordinate, ILayer targetLayer, boolean acceptNegativePosition) {
        if (rowPositionCoordinate != null) {
            ILayer layer = rowPositionCoordinate.getLayer();
            if (layer == targetLayer) {
                return rowPositionCoordinate;
            }
            int rowPosition = rowPositionCoordinate.getRowPosition();
            int underlyingRowPosition = layer.localToUnderlyingRowPosition(rowPosition);
            if (!acceptNegativePosition && underlyingRowPosition < 0) {
                return null;
            }
            Collection<ILayer> underlyingLayers = layer.getUnderlyingLayersByRowPosition(rowPosition);
            if (underlyingLayers != null) {
                for (ILayer underlyingLayer : underlyingLayers) {
                    RowPositionCoordinate convertedRowPositionCoordinate;
                    if (underlyingLayer == null || (convertedRowPositionCoordinate = LayerCommandUtil.convertRowPositionToTargetContext(new RowPositionCoordinate(underlyingLayer, underlyingRowPosition), targetLayer, acceptNegativePosition)) == null) continue;
                    return convertedRowPositionCoordinate;
                }
            }
        }
        return null;
    }
}

