/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemmanagement.ui.editors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotationModel;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotationModelListener;
import org.eclipse.fordiac.ide.gef.widgets.PackageInfoWidget;
import org.eclipse.fordiac.ide.model.commands.change.ChangeApplicationOrderCommand;
import org.eclipse.fordiac.ide.model.commands.create.CreateApplicationCommand;
import org.eclipse.fordiac.ide.model.commands.delete.DeleteApplicationCommand;
import org.eclipse.fordiac.ide.model.data.provider.DataItemProviderAdapterFactory;
import org.eclipse.fordiac.ide.model.emf.SingleRecursiveContentAdapter;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.CompilerInfo;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.systemmanagement.SystemManager;
import org.eclipse.fordiac.ide.systemmanagement.ui.Messages;
import org.eclipse.fordiac.ide.systemmanagement.ui.editors.ApplicationViewerCellModifier;
import org.eclipse.fordiac.ide.systemmanagement.ui.providers.SystemElementItemProviderAdapterFactory;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.fordiac.ide.ui.widget.AddDeleteReorderListWidget;
import org.eclipse.fordiac.ide.ui.widget.TableWidgetFactory;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackEvent;
import org.eclipse.gef.commands.CommandStackEventListener;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.RedoAction;
import org.eclipse.gef.ui.actions.UndoAction;
import org.eclipse.gef.ui.actions.UpdateAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorSite;

public class SystemEditor
extends EditorPart
implements CommandStackEventListener,
ISelectionListener,
ISelectionProvider,
IReusableEditor {
    private static final ComposedAdapterFactory systemAdapterFactory = new ComposedAdapterFactory(SystemEditor.createFactoryList());
    private AutomationSystem system;
    private CommandStack commandStack;
    private GraphicalAnnotationModel annotationModel;
    private ScrolledForm form;
    private PackageInfoWidget typeInfo;
    private TableViewer appTableViewer;
    private TreeViewer sysConfTreeViewer;
    private ActionRegistry actionRegistry;
    private final List<String> selectionActions = new ArrayList<String>();
    private final List<String> stackActions = new ArrayList<String>();
    private final List<String> propertyActions = new ArrayList<String>();
    private final Adapter appListener = new SingleRecursiveContentAdapter(){

        public void notifyChanged(Notification notification) {
            super.notifyChanged(notification);
            Display.getDefault().asyncExec(() -> {
                if (SystemEditor.this.appTableViewer != null && !SystemEditor.this.appTableViewer.getControl().isDisposed()) {
                    SystemEditor.this.appTableViewer.refresh();
                }
            });
            Object object = notification.getNewValue();
            if (object instanceof CompilerInfo) {
                CompilerInfo compInfo = (CompilerInfo)object;
                compInfo.eAdapters().add((Object)SystemEditor.this.compilerInfoListener);
                Object object2 = notification.getOldValue();
                if (object2 instanceof CompilerInfo) {
                    CompilerInfo oldCompInfo = (CompilerInfo)object2;
                    oldCompInfo.eAdapters().remove((Object)SystemEditor.this.compilerInfoListener);
                }
            }
        }
    };
    private final Adapter sysConfListener = new AdapterImpl(){

        public void notifyChanged(Notification notification) {
            if (SystemEditor.this.sysConfTreeViewer != null && !SystemEditor.this.sysConfTreeViewer.getControl().isDisposed()) {
                SystemEditor.this.sysConfTreeViewer.refresh();
            }
        }
    };
    private final Adapter compilerInfoListener = new AdapterImpl(){

        public void notifyChanged(Notification notification) {
            SystemEditor.this.typeInfo.refresh();
        }
    };
    private final GraphicalAnnotationModelListener annotationModelListener = event -> {
        if (this.typeInfo != null && !this.form.isDisposed()) {
            this.form.getDisplay().asyncExec(() -> ((PackageInfoWidget)this.typeInfo).refreshAnnotations());
        }
    };

    public void stackChanged(CommandStackEvent event) {
        this.updateActions(this.stackActions);
    }

    public void dispose() {
        if (this.system != null) {
            this.getCommandStack().removeCommandStackEventListener((CommandStackEventListener)this);
            this.system.eAdapters().remove((Object)this.appListener);
            this.system.getSystemConfiguration().eAdapters().remove((Object)this.sysConfListener);
            if (this.system.getCompilerInfo() != null) {
                this.system.getCompilerInfo().eAdapters().remove((Object)this.compilerInfoListener);
            }
        }
        this.removeAnnotationModelListener();
        this.getSite().getWorkbenchWindow().getSelectionService().removeSelectionListener((ISelectionListener)this);
        this.getActionRegistry().dispose();
        super.dispose();
    }

    protected void firePropertyChange(int property) {
        super.firePropertyChange(property);
        this.updateActions(this.propertyActions);
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
        if (iWorkbenchPartSite instanceof MultiPageEditorSite) {
            MultiPageEditorSite multiPageEditorSite = (MultiPageEditorSite)iWorkbenchPartSite;
            this.commandStack = (CommandStack)multiPageEditorSite.getMultiPageEditor().getAdapter(CommandStack.class);
            this.getCommandStack().addCommandStackEventListener((CommandStackEventListener)this);
        }
        this.setInput(input);
        site.getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
        this.initializeActionRegistry();
        this.setActionHandlers(site);
    }

    public void setInput(IEditorInput input) {
        IWorkbenchPartSite iWorkbenchPartSite;
        if (input instanceof FileEditorInput) {
            FileEditorInput fileEditorInput = (FileEditorInput)input;
            this.system = SystemManager.INSTANCE.getSystem(fileEditorInput.getFile());
            if (this.system != null) {
                this.setPartName(this.system.getName());
                this.system.eAdapters().add((Object)this.appListener);
                this.system.getSystemConfiguration().eAdapters().add((Object)this.sysConfListener);
                if (this.system.getCompilerInfo() != null) {
                    this.system.getCompilerInfo().eAdapters().add((Object)this.compilerInfoListener);
                }
            }
        }
        if ((iWorkbenchPartSite = this.getSite()) instanceof MultiPageEditorSite) {
            MultiPageEditorSite multiPageEditorSite = (MultiPageEditorSite)iWorkbenchPartSite;
            this.removeAnnotationModelListener();
            this.annotationModel = (GraphicalAnnotationModel)multiPageEditorSite.getMultiPageEditor().getAdapter(GraphicalAnnotationModel.class);
            this.addAnnotationModelListener();
        }
        super.setInputWithNotify(input);
    }

    private void setActionHandlers(IEditorSite site) {
        ActionRegistry registry = this.getActionRegistry();
        IActionBars bars = site.getActionBars();
        String id = ActionFactory.UNDO.getId();
        bars.setGlobalActionHandler(id, registry.getAction((Object)id));
        id = ActionFactory.REDO.getId();
        bars.setGlobalActionHandler(id, registry.getAction((Object)id));
        id = ActionFactory.DELETE.getId();
        bars.setGlobalActionHandler(id, registry.getAction((Object)id));
        bars.updateActionBars();
    }

    public boolean isDirty() {
        return this.system != null && this.getCommandStack().isDirty();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void executeCommand(Command cmd) {
        CommandStack commandStack = this.getCommandStack();
        if (commandStack != null && cmd.canExecute()) {
            commandStack.execute(cmd);
        }
    }

    public void createPartControl(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        this.form = toolkit.createScrolledForm(parent);
        GridLayoutFactory.fillDefaults().applyTo(this.form.getBody());
        Composite parentComposite = toolkit.createComposite(this.form.getBody());
        toolkit.adapt(parentComposite);
        parentComposite.setLayout((Layout)new GridLayout(1, false));
        parentComposite.setLayoutData((Object)new GridData(1808));
        Composite appSysConfComp = toolkit.createComposite(parentComposite);
        appSysConfComp.setLayout((Layout)new GridLayout(2, true));
        appSysConfComp.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createApplicationsSection(toolkit, appSysConfComp);
        this.createSysconfSection(toolkit, appSysConfComp);
        this.createInfoSection(toolkit, parentComposite);
        this.getSite().setSelectionProvider((ISelectionProvider)this);
        if (this.system != null) {
            this.typeInfo.initialize((LibraryElement)this.system, this::executeCommand);
            this.typeInfo.refresh();
            this.appTableViewer.setInput((Object)this.system.getApplication());
            this.sysConfTreeViewer.setInput((Object)this.system.getSystemConfiguration());
            this.addAnnotationModelListener();
        }
    }

    protected void addAnnotationModelListener() {
        if (this.annotationModel != null) {
            this.annotationModel.addAnnotationModelListener(this.annotationModelListener);
        }
    }

    protected void removeAnnotationModelListener() {
        if (this.annotationModel != null) {
            this.annotationModel.removeAnnotationModelListener(this.annotationModelListener);
        }
    }

    private void createInfoSection(FormToolkit toolkit, Composite parent) {
        Section infoSection = SystemEditor.createExpandableSection(toolkit, parent, Messages.SystemEditor_SystemInformation);
        this.typeInfo = new PackageInfoWidget(toolkit, () -> this.annotationModel);
        Composite composite = toolkit.createComposite((Composite)infoSection);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(true).applyTo(composite);
        this.typeInfo.createControls(composite);
        infoSection.setClient((Control)composite);
    }

    private static Section createExpandableSection(FormToolkit toolkit, Composite parent, String text) {
        Section section = toolkit.createSection(parent, 322);
        section.setLayoutData((Object)new GridData(4, 4, true, false));
        section.setText(text);
        return section;
    }

    private void createApplicationsSection(FormToolkit toolkit, Composite bottomComp) {
        Section appSection = SystemEditor.createExpandableSection(toolkit, bottomComp, Messages.SystemEditor_Applications);
        Composite appSecComposite = toolkit.createComposite((Composite)appSection);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(appSecComposite);
        appSection.setClient((Control)appSecComposite);
        AddDeleteReorderListWidget actionMgmButtons = new AddDeleteReorderListWidget();
        actionMgmButtons.createControls(appSecComposite, toolkit);
        this.appTableViewer = TableWidgetFactory.createTableViewer((Composite)appSecComposite);
        this.configureActionTableLayout(this.appTableViewer);
        this.appTableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        actionMgmButtons.bindToTableViewer(this.appTableViewer, cmd -> this.getCommandStack().execute(cmd), ref -> new CreateApplicationCommand(this.system, SystemEditor.getAppName((Application)ref)), ref -> new DeleteApplicationCommand((Application)ref), ref -> new ChangeApplicationOrderCommand((Application)ref, true), ref -> new ChangeApplicationOrderCommand((Application)ref, false));
    }

    private static String getAppName(Application ref) {
        return ref != null ? ref.getName() : null;
    }

    private void configureActionTableLayout(TableViewer appTableViewer) {
        Table table = appTableViewer.getTable();
        TableViewerColumn nameCol = new TableViewerColumn(appTableViewer, 16384);
        nameCol.getColumn().setText(FordiacMessages.Name);
        nameCol.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public Image getImage(Object element) {
                return FordiacImage.ICON_APPLICATION.getImage();
            }

            public String getText(Object element) {
                if (element instanceof Application) {
                    Application app = (Application)element;
                    return app.getName();
                }
                return element.toString();
            }
        });
        TableViewerColumn commentCol = new TableViewerColumn(appTableViewer, 16384);
        commentCol.getColumn().setText(FordiacMessages.Comment);
        commentCol.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof Application) {
                    Application app = (Application)element;
                    return app.getComment();
                }
                return element.toString();
            }
        });
        TableLayout tabLayout = new TableLayout();
        tabLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 50));
        tabLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(2, 50));
        table.setLayout((Layout)tabLayout);
        appTableViewer.setColumnProperties(new String[]{"APP_NAME", "APP_COMMENT"});
        appTableViewer.setCellModifier((ICellModifier)new ApplicationViewerCellModifier(this.getCommandStack()));
        appTableViewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)table), new TextCellEditor((Composite)table)});
    }

    private void createSysconfSection(FormToolkit toolkit, Composite bottomComp) {
        Section sysConfSection = SystemEditor.createExpandableSection(toolkit, bottomComp, Messages.SystemEditor_SystemConfiguration);
        sysConfSection.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite sysConfSecComposite = toolkit.createComposite((Composite)sysConfSection);
        GridLayoutFactory.fillDefaults().applyTo(sysConfSecComposite);
        sysConfSection.setClient((Control)sysConfSecComposite);
        Tree tree = toolkit.createTree(sysConfSecComposite, 2820);
        tree.setLayoutData((Object)new GridData(4, 4, true, true));
        this.sysConfTreeViewer = new TreeViewer(tree);
        this.sysConfTreeViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)systemAdapterFactory));
        this.sysConfTreeViewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)systemAdapterFactory));
    }

    public void setFocus() {
        this.form.setFocus();
    }

    private CommandStack getCommandStack() {
        return this.commandStack;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (((Object)((Object)this)).equals(this.getSite().getPage().getActiveEditor())) {
            this.updateActions(this.selectionActions);
        }
    }

    private void createActions() {
        ActionRegistry registry = this.getActionRegistry();
        UndoAction action = new UndoAction((IEditorPart)this);
        registry.registerAction((IAction)action);
        this.getStackActions().add(action.getId());
        action = new RedoAction((IEditorPart)this);
        registry.registerAction((IAction)action);
        this.getStackActions().add(action.getId());
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == CommandStack.class) {
            return adapter.cast(this.getCommandStack());
        }
        if (adapter == ActionRegistry.class) {
            return adapter.cast(this.getActionRegistry());
        }
        if (adapter == GraphicalAnnotationModel.class) {
            return adapter.cast(this.annotationModel);
        }
        return (T)super.getAdapter(adapter);
    }

    private List<String> getStackActions() {
        return this.stackActions;
    }

    private void initializeActionRegistry() {
        this.createActions();
        this.updateActions(this.propertyActions);
        this.updateActions(this.stackActions);
    }

    private void updateActions(List<String> actionIds) {
        ActionRegistry registry = this.getActionRegistry();
        actionIds.forEach(id -> {
            IAction action = registry.getAction(id);
            if (action instanceof UpdateAction) {
                UpdateAction ua = (UpdateAction)action;
                ua.update();
            }
        });
    }

    private ActionRegistry getActionRegistry() {
        if (this.actionRegistry == null) {
            this.actionRegistry = new ActionRegistry();
        }
        return this.actionRegistry;
    }

    private static List<AdapterFactory> createFactoryList() {
        ArrayList<AdapterFactory> factories = new ArrayList<AdapterFactory>(2);
        factories.add((AdapterFactory)new SystemElementItemProviderAdapterFactory());
        factories.add((AdapterFactory)new DataItemProviderAdapterFactory());
        return factories;
    }

    public ISelection getSelection() {
        return this.system != null ? new StructuredSelection((Object)this.system) : StructuredSelection.EMPTY;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public void setSelection(ISelection selection) {
    }
}

