/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataimport;

import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.NameRepository;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.dataimport.CommonElementImporter;
import org.eclipse.fordiac.ide.model.dataimport.FBNetworkImporter;
import org.eclipse.fordiac.ide.model.dataimport.exceptions.TypeImportException;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.errormarker.FordiacErrorMarkerInterfaceHelper;
import org.eclipse.fordiac.ide.model.errormarker.FordiacMarkerHelper;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterConnection;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.ConnectionRoutingData;
import org.eclipse.fordiac.ide.model.libraryElement.DataConnection;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorMarkerFBNElement;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorMarkerInterface;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.EventConnection;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.resource.TypeImportDiagnostic;
import org.eclipse.fordiac.ide.model.typelibrary.AdapterTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.EventTypeLibrary;
import org.eclipse.fordiac.ide.model.validation.LinkConstraints;

public final class ConnectionHelper {
    public static <T extends Connection> ConnectionBuilder<T> createConnectionBuilder(EClass conType, FBNetworkImporter importer) throws XMLStreamException, TypeImportException {
        Connection connection = (Connection)LibraryElementFactory.eINSTANCE.create(conType);
        String sourceElement = importer.getAttributeValue("Source");
        String destinationElement = importer.getAttributeValue("Destination");
        String commentElement = importer.getAttributeValue("Comment");
        if (commentElement != null) {
            connection.setComment(commentElement);
        }
        ConnectionHelper.parseConnectionRouting(connection, importer);
        importer.parseAttributes(connection);
        return new ConnectionBuilder<Connection>(sourceElement, destinationElement, connection, importer);
    }

    private static void parseConnectionRouting(Connection connection, CommonElementImporter importer) {
        String dyElement;
        String dx2Element;
        ConnectionRoutingData routingData = LibraryElementFactory.eINSTANCE.createConnectionRoutingData();
        String dx1Element = importer.getAttributeValue("dx1");
        if (dx1Element != null) {
            routingData.setDx1(ConnectionHelper.parseConnectionValue(dx1Element));
        }
        if ((dx2Element = importer.getAttributeValue("dx2")) != null) {
            routingData.setDx2(ConnectionHelper.parseConnectionValue(dx2Element));
        }
        if ((dyElement = importer.getAttributeValue("dy")) != null) {
            routingData.setDy(ConnectionHelper.parseConnectionValue(dyElement));
        }
        connection.setRoutingData(routingData);
    }

    private static double parseConnectionValue(String value) {
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException ex) {
            return 0.0;
        }
    }

    private ConnectionHelper() {
        throw new UnsupportedOperationException();
    }

    public static class ConnectionBuilder<T extends Connection> {
        private final Set<ConnectionState> connectionState = EnumSet.of(ConnectionState.VALID);
        final T connection;
        final FBNetworkImporter importer;
        private final String destinationString;
        private String fullDstPinName;
        private InterfaceList destInterfaceList;
        private final String sourceString;
        private String fullSrcPinName;
        private InterfaceList srcInterfaceList;

        public ConnectionBuilder(String sourceString, String destinationString, T connection, FBNetworkImporter importer) {
            this.sourceString = sourceString;
            this.destinationString = destinationString;
            this.connection = connection;
            this.importer = importer;
            connection.setSource(this.getConnectionEndPoint(sourceString, false));
            connection.setDestination(this.getConnectionEndPoint(destinationString, true));
        }

        public void validate() {
            IInterfaceElement sourcePin = this.connection.getSource();
            IInterfaceElement destPin = this.connection.getDestination();
            if (sourcePin != null && destPin != null) {
                if (!LinkConstraints.typeCheck(sourcePin, destPin)) {
                    this.connectionState.add(ConnectionState.DATATYPE_MISSMATCH);
                    this.connectionState.remove((Object)ConnectionState.VALID);
                }
                if (LinkConstraints.duplicateConnection(sourcePin, destPin)) {
                    this.connectionState.add(ConnectionState.DUPLICATE);
                    this.connectionState.remove((Object)ConnectionState.VALID);
                }
                return;
            }
            if (sourcePin != null) {
                this.connectionState.add(ConnectionState.SOURCE_ENDPOINT_EXISTS);
            } else {
                this.connectionState.add(ConnectionState.SOURCE_ENDPOINT_MISSING);
                this.connectionState.remove((Object)ConnectionState.VALID);
            }
            if (this.srcInterfaceList != null) {
                this.connectionState.add(ConnectionState.SOURCE_EXITS);
            } else {
                this.connectionState.add(ConnectionState.SOURCE_MISSING);
                this.connectionState.remove((Object)ConnectionState.VALID);
            }
            if (destPin != null) {
                this.connectionState.add(ConnectionState.DEST_ENPOINT_EXITS);
            } else {
                this.connectionState.add(ConnectionState.DEST_ENDPOINT_MISSING);
                this.connectionState.remove((Object)ConnectionState.VALID);
            }
            if (this.destInterfaceList != null) {
                this.connectionState.add(ConnectionState.DEST_EXISTS);
            } else {
                this.connectionState.add(ConnectionState.DEST_MISSING);
                this.connectionState.remove((Object)ConnectionState.VALID);
            }
        }

        public void repair() {
            if (this.isMissingConnectionSource()) {
                this.connection.setSource(this.getConnectionEndPoint(this.sourceString, false));
            }
            if (this.isMissingConnectionDestination()) {
                this.connection.setDestination(this.getConnectionEndPoint(this.destinationString, true));
            }
            this.connectionState.clear();
            this.connectionState.add(ConnectionState.VALID);
            this.validate();
            this.handleErrorCases();
            if (this.getConnection() != null) {
                this.importer.getFbNetwork().addConnection((Connection)this.connection);
            }
        }

        public void handleErrorCases() {
            if (this.isMissingConnectionDestination()) {
                this.handleMissingConnectionDestination();
            }
            if (this.isMissingConnectionDestinationEndpoint()) {
                this.createErrorMarkerInterface(true);
            }
            if (this.isMissingConnectionSource()) {
                this.handleMissingConnectionSource();
            }
            if (this.isMissingConnectionSourceEndpoint()) {
                this.createErrorMarkerInterface(false);
            }
            if (this.isMissingSourceAndDestEndpoint()) {
                this.handleMissingSrcAndDestEnpoint();
            }
            if (this.isEmptyConnection()) {
                this.importer.getErrors().add(new TypeImportDiagnostic("Connection missing both source and destination element", MessageFormat.format("{0} -> {1}", this.sourceString, this.destinationString), this.importer.getLineNumber()));
            }
        }

        public String getSourceFbName() {
            if (this.sourceString == null) {
                return Messages.ConnectionHelper_ErrorMarker_Source_Missing;
            }
            String[] qualNames = this.sourceString.split("\\.");
            if (qualNames.length == 0) {
                return Messages.ConnectionHelper_ErrorMarker_Source_Missing;
            }
            return qualNames[0];
        }

        public String getDestFbName() {
            if (this.destinationString == null) {
                return Messages.ConnectionHelper_ErrorMarker_Dest_Missing;
            }
            String[] qualNames = this.destinationString.split("\\.");
            if (qualNames.length == 0) {
                return Messages.ConnectionHelper_ErrorMarker_Dest_Missing;
            }
            return qualNames[0];
        }

        public Set<ConnectionState> getConnectionState() {
            return this.connectionState;
        }

        public IInterfaceElement getDestinationEndpoint() {
            return this.connection.getDestination();
        }

        public IInterfaceElement getSourceEndpoint() {
            return this.connection.getSource();
        }

        public T getConnection() {
            return this.isEmptyConnection() ? null : (T)this.connection;
        }

        public boolean isMissingConnectionDestination() {
            return this.connectionState.containsAll(EnumSet.of(ConnectionState.DEST_MISSING, ConnectionState.SOURCE_ENDPOINT_EXISTS));
        }

        public boolean isValidConnection() {
            return this.connectionState.contains((Object)ConnectionState.VALID);
        }

        public boolean isDuplicate() {
            return this.connectionState.contains((Object)ConnectionState.DUPLICATE);
        }

        public boolean isDataTypeMissmatch() {
            return this.connectionState.contains((Object)ConnectionState.DATATYPE_MISSMATCH);
        }

        public boolean isMissingConnectionDestinationEndpoint() {
            return this.connectionState.containsAll(EnumSet.of(ConnectionState.DEST_ENDPOINT_MISSING, ConnectionState.SOURCE_EXITS, ConnectionState.SOURCE_ENDPOINT_EXISTS, ConnectionState.DEST_EXISTS));
        }

        public boolean isMissingConnectionSource() {
            return this.connectionState.containsAll(EnumSet.of(ConnectionState.SOURCE_MISSING, ConnectionState.SOURCE_ENDPOINT_MISSING, ConnectionState.DEST_EXISTS, ConnectionState.DEST_ENPOINT_EXITS));
        }

        public boolean isMissingConnectionSourceEndpoint() {
            return this.connectionState.containsAll(EnumSet.of(ConnectionState.SOURCE_ENDPOINT_MISSING, ConnectionState.SOURCE_EXITS, ConnectionState.DEST_EXISTS, ConnectionState.DEST_ENPOINT_EXITS));
        }

        public boolean isMissingSourceAndDestEndpoint() {
            return this.connectionState.containsAll(EnumSet.of(ConnectionState.SOURCE_ENDPOINT_MISSING, ConnectionState.DEST_ENDPOINT_MISSING, ConnectionState.SOURCE_EXITS, ConnectionState.DEST_EXISTS));
        }

        public boolean isEmptyConnection() {
            return this.connectionState.containsAll(EnumSet.of(ConnectionState.SOURCE_ENDPOINT_MISSING, ConnectionState.DEST_ENDPOINT_MISSING, ConnectionState.SOURCE_MISSING, ConnectionState.DEST_MISSING));
        }

        public boolean dataInputHasMultipleConnections() {
            IInterfaceElement sourceEndpoint = this.connection.getSource();
            IInterfaceElement destinationEndpoint = this.connection.getDestination();
            return !(sourceEndpoint instanceof Event) && sourceEndpoint.isIsInput() && sourceEndpoint.getInputConnections().size() > 1 || !(destinationEndpoint instanceof Event) && destinationEndpoint.isIsInput() && destinationEndpoint.getInputConnections().size() > 1;
        }

        public String getSourcePinName() {
            return ConnectionBuilder.getPinName(this.sourceString, this.srcInterfaceList, this.fullSrcPinName);
        }

        public String getDestinationPinName() {
            return ConnectionBuilder.getPinName(this.destinationString, this.destInterfaceList, this.fullDstPinName);
        }

        private static String getPinName(String pinIdentifier, InterfaceList il, String fullPinName) {
            if (fullPinName != null) {
                return fullPinName;
            }
            if (pinIdentifier != null && !pinIdentifier.isBlank()) {
                EObject eObject;
                if (il != null && (eObject = il.eContainer()) instanceof BlockFBNetworkElement) {
                    BlockFBNetworkElement bfbNEl = (BlockFBNetworkElement)eObject;
                    return pinIdentifier.substring(bfbNEl.getName().length() + 1);
                }
                return pinIdentifier;
            }
            return "";
        }

        private void handleMissingConnectionSource() {
            ErrorMarkerFBNElement sourceFB = FordiacMarkerHelper.createErrorMarkerFB(this.getSourceFbName());
            this.srcInterfaceList = sourceFB.getInterface();
            this.importer.getFbNetwork().getNetworkElements().add((Object)sourceFB);
            sourceFB.setName(NameRepository.createUniqueName(sourceFB, sourceFB.getName()));
            this.createErrorMarkerInterface(false);
        }

        private void handleMissingConnectionDestination() {
            ErrorMarkerFBNElement destinationFb = FordiacMarkerHelper.createErrorMarkerFB(this.getDestFbName());
            this.destInterfaceList = destinationFb.getInterface();
            this.importer.getFbNetwork().getNetworkElements().add((Object)destinationFb);
            destinationFb.setName(NameRepository.createUniqueName(destinationFb, destinationFb.getName()));
            this.createErrorMarkerInterface(true);
        }

        private void handleMissingSrcAndDestEnpoint() {
            DataType pinType = this.determineConnectionType();
            ErrorMarkerInterface srcEndpoint = FordiacErrorMarkerInterfaceHelper.createErrorMarkerInterface(pinType, this.getSourcePinName(), false, this.srcInterfaceList);
            ErrorMarkerInterface destEndpoint = FordiacErrorMarkerInterfaceHelper.createErrorMarkerInterface(pinType, this.getDestinationPinName(), true, this.destInterfaceList);
            this.connection.setSource(srcEndpoint);
            this.connection.setDestination(destEndpoint);
        }

        private DataType determineConnectionType() {
            if (this.connection instanceof EventConnection) {
                return EventTypeLibrary.getInstance().getType(null);
            }
            if (this.connection instanceof AdapterConnection) {
                AdapterTypeEntry entry = this.importer.getTypeLibrary().getAdapterTypeEntry("ANY_ADAPTER");
                if (entry != null) {
                    return entry.getType();
                }
                return LibraryElementFactory.eINSTANCE.createAdapterType();
            }
            if (this.connection instanceof DataConnection) {
                return IecTypes.GenericTypes.ANY;
            }
            return null;
        }

        private ErrorMarkerInterface createErrorMarkerInterface(boolean isInput) {
            IInterfaceElement oppositeEndpoint;
            IInterfaceElement iInterfaceElement = oppositeEndpoint = isInput ? this.getSourceEndpoint() : this.getDestinationEndpoint();
            if (oppositeEndpoint == null) {
                this.getConnectionState().add(ConnectionState.MISSING_TYPE);
                return null;
            }
            DataType type = oppositeEndpoint.getType();
            if (type == null) {
                type = this.determineConnectionType();
            }
            InterfaceList ieList = isInput ? this.destInterfaceList : this.srcInterfaceList;
            String pinName = isInput ? this.getDestinationPinName() : this.getSourcePinName();
            ErrorMarkerInterface errorMarkerInterface = FordiacErrorMarkerInterfaceHelper.createErrorMarkerInterface(type, pinName, isInput, ieList);
            if (isInput) {
                this.connection.setSource(oppositeEndpoint);
                this.connection.setDestination(errorMarkerInterface);
            } else {
                this.connection.setSource(errorMarkerInterface);
                this.connection.setDestination(oppositeEndpoint);
            }
            return errorMarkerInterface;
        }

        private IInterfaceElement getConnectionEndPoint(String path, boolean isInput) {
            if (path == null) {
                return null;
            }
            int separatorPos = path.indexOf(46);
            if (separatorPos == -1) {
                if (isInput) {
                    this.destInterfaceList = this.importer.getInterfaceList();
                    this.fullDstPinName = path;
                } else {
                    this.srcInterfaceList = this.importer.getInterfaceList();
                    this.fullSrcPinName = path;
                }
                return this.importer.getContainingInterfaceElement(path, this.connection.eClass(), isInput);
            }
            String elementName = path.substring(0, separatorPos);
            FBNetworkElement element = this.importer.findFBNetworkElement(elementName);
            while (element == null && separatorPos != -1) {
                if ((separatorPos = path.indexOf(46, separatorPos + 1)) == -1) {
                    return null;
                }
                elementName = path.substring(0, separatorPos);
                element = this.importer.findFBNetworkElement(elementName);
            }
            if (element instanceof BlockFBNetworkElement) {
                BlockFBNetworkElement blockFbnElem = (BlockFBNetworkElement)element;
                String pinName = path.substring(separatorPos + 1);
                InterfaceList ieList = blockFbnElem.getInterface();
                if (isInput) {
                    this.destInterfaceList = ieList;
                    this.fullDstPinName = pinName;
                } else {
                    this.srcInterfaceList = ieList;
                    this.fullSrcPinName = pinName;
                }
                return FBNetworkImporter.getInterfaceElement(ieList, pinName, this.connection.eClass(), isInput);
            }
            return null;
        }
    }

    public static enum ConnectionState {
        VALID,
        SOURCE_MISSING,
        SOURCE_ENDPOINT_MISSING,
        DEST_MISSING,
        DEST_ENDPOINT_MISSING,
        SOURCE_EXITS,
        SOURCE_ENDPOINT_EXISTS,
        DEST_EXISTS,
        DEST_ENPOINT_EXITS,
        MISSING_TYPE,
        DATATYPE_MISSMATCH,
        DUPLICATE;

    }
}

