/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.value;

import org.eclipse.fordiac.ide.model.data.CharType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.eval.value.AnyCharValue;
import org.eclipse.fordiac.ide.model.eval.value.AnyCharsValue;
import org.eclipse.fordiac.ide.model.eval.value.AnySCharsValue;
import org.eclipse.fordiac.ide.model.value.StringValueConverter;

public final class CharValue
implements AnyCharValue,
AnySCharsValue {
    public static final CharValue DEFAULT = new CharValue(0);
    private final byte value;

    private CharValue(byte value) {
        this.value = value;
    }

    public static CharValue toCharValue(byte value) {
        return new CharValue(value);
    }

    public static CharValue toCharValue(String value) {
        return CharValue.toCharValue(value.isEmpty() ? (byte)0 : (byte)value.charAt(0));
    }

    public static CharValue toCharValue(AnyCharsValue value) {
        return CharValue.toCharValue((byte)value.charValue());
    }

    public CharType getType() {
        return IecTypes.ElementaryTypes.CHAR;
    }

    @Override
    public int length() {
        return 1;
    }

    @Override
    public char charValue() {
        return (char)this.value;
    }

    @Override
    public String stringValue() {
        return Character.toString((char)this.value);
    }

    public int hashCode() {
        return Byte.hashCode(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CharValue other = (CharValue)obj;
        return this.value == other.value;
    }

    public String toString() {
        return StringValueConverter.INSTANCE.toString(this.stringValue());
    }
}

