/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.impl;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.fordiac.ide.model.eval.EvaluatorFactory;

public class EvaluatorFactoryRegistryImpl
implements EvaluatorFactory.Registry {
    private final Map<String, Map<Class<?>, EvaluatorFactory>> variantClassToFactoryMap = new ConcurrentHashMap();

    @Override
    public EvaluatorFactory getFactory(String variant, Class<?> sourceClass) {
        Map<Class<?>, EvaluatorFactory> classToFactoryMap = this.variantClassToFactoryMap.get(variant);
        if (classToFactoryMap != null) {
            return classToFactoryMap.get(sourceClass);
        }
        return null;
    }

    @Override
    public EvaluatorFactory registerFactory(String variant, Class<?> sourceClass, EvaluatorFactory factory) {
        return this.variantClassToFactoryMap.computeIfAbsent(Objects.requireNonNullElse(variant, "default"), unused -> new ConcurrentHashMap()).put(sourceClass, factory);
    }

    @Override
    public Map<String, Map<Class<?>, EvaluatorFactory>> getVariantClassToFactoryMap() {
        return this.variantClassToFactoryMap;
    }
}

