/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.library;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.fordiac.ide.library.LibraryManager;
import org.osgi.framework.VersionRange;

class DependencyNode {
    private final String symbolicName;
    private VersionRange range;
    private final Map<String, VersionRange> causes;
    private boolean changed;

    public DependencyNode(String symbolicName) {
        this.symbolicName = symbolicName;
        this.range = LibraryManager.ALL_RANGE;
        this.causes = new HashMap<String, VersionRange>();
        this.changed = true;
    }

    public DependencyNode(String symbolicName, String causeName, VersionRange causeRange) {
        this(symbolicName);
        this.causes.put(causeName, causeRange);
        this.recalculate();
    }

    public String getSymbolicName() {
        return this.symbolicName;
    }

    public VersionRange getRange() {
        return this.range;
    }

    public boolean isChanged() {
        return this.changed;
    }

    public Map<String, VersionRange> getCauses() {
        return this.causes;
    }

    public boolean putCause(String causeName, VersionRange causeRange) {
        this.causes.put(causeName, causeRange);
        return this.recalculate();
    }

    public boolean removeCause(String causeName) {
        this.causes.remove(causeName);
        return this.recalculate();
    }

    public boolean isValid() {
        return !this.causes.isEmpty() && !this.range.isEmpty();
    }

    public boolean isRangeEmpty() {
        return this.range.isEmpty();
    }

    public boolean recalculate() {
        VersionRange calc = LibraryManager.ALL_RANGE;
        for (VersionRange r : this.causes.values()) {
            calc = calc.intersection(new VersionRange[]{r});
        }
        if (this.range.equals((Object)calc)) {
            return false;
        }
        this.range = calc;
        this.changed = true;
        return true;
    }
}

