/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.debug.ui.handler;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.fordiac.ide.deployment.debug.DeploymentDebugDevice;
import org.eclipse.fordiac.ide.deployment.debug.DeploymentLaunchConfigurationDelegate;
import org.eclipse.fordiac.ide.deployment.debug.ui.Messages;
import org.eclipse.fordiac.ide.deployment.debug.watch.DeploymentDebugWatchUtils;
import org.eclipse.fordiac.ide.deployment.exceptions.DeploymentException;
import org.eclipse.fordiac.ide.deployment.interactors.IDeviceManagementInteractor;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class AbstractDeploymentHandler<T extends INamedElement>
extends AbstractHandler {
    private static final int CONNECTION_POLLING_INTERVAL = 100;

    public final Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection iSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (iSelection instanceof IStructuredSelection) {
            IStructuredSelection selection = (IStructuredSelection)iSelection;
            Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
            try {
                for (Object selectedElement : selection) {
                    this.execute(selectedElement, shell);
                }
            }
            catch (DeploymentException e) {
                ErrorDialog.openError((Shell)shell, null, null, (IStatus)Status.error((String)e.getLocalizedMessage(), (Throwable)e));
            }
        }
        return null;
    }

    private void execute(Object selectedElement, Shell shell) throws DeploymentException, ExecutionException {
        List<T> targets = this.getTargets(selectedElement);
        if (targets == null) {
            return;
        }
        for (INamedElement target : targets) {
            this.execute((T)target, shell);
        }
    }

    private void execute(T target, Shell shell) throws DeploymentException, ExecutionException {
        Resource resource = DeploymentDebugWatchUtils.getResource(target);
        if (resource == null) {
            throw new DeploymentException(MessageFormat.format(Messages.AbstractDeploymentHandler_ElementNotInResource, target.getQualifiedName()));
        }
        Optional<DeploymentDebugDevice> activeDevice = AbstractDeploymentHandler.findActiveDevice(resource.getDevice());
        if (activeDevice.isEmpty()) {
            this.perform(target, resource, shell);
        } else {
            this.perform(target, resource, (IDeviceManagementInteractor)activeDevice.get().getDeviceManagementExecutorService(), shell);
        }
    }

    protected void perform(T target, Resource resource, Shell shell) throws DeploymentException, ExecutionException {
        AutomationSystem system = resource.getAutomationSystem();
        if (system == null) {
            throw new DeploymentException(MessageFormat.format(Messages.AbstractDeploymentHandler_ElementNotInSystem, target.getQualifiedName()));
        }
        if (!MessageDialog.openConfirm((Shell)shell, (String)Messages.AbstractDeploymentHandler_LaunchDialogTitle, (String)MessageFormat.format(Messages.AbstractDeploymentHandler_LaunchDialogMessage, system.getName()))) {
            return;
        }
        ILaunch launch = AbstractDeploymentHandler.launch(system);
        IDeviceManagementInteractor interactor = AbstractDeploymentHandler.waitForConnection(shell, launch, resource.getDevice());
        if (interactor != null) {
            this.perform(target, resource, interactor, shell);
        }
    }

    protected abstract void perform(T var1, Resource var2, IDeviceManagementInteractor var3, Shell var4) throws DeploymentException;

    protected abstract List<T> getTargets(Object var1);

    protected static ILaunch launch(AutomationSystem system) throws DeploymentException {
        Optional<IResource> resource = AbstractDeploymentHandler.getResource(system);
        if (resource.isEmpty()) {
            throw new DeploymentException(MessageFormat.format(Messages.AbstractDeploymentHandler_NoFileForSystem, system.getName()));
        }
        try {
            ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType type = manager.getLaunchConfigurationType("org.eclipse.fordiac.ide.deployment.debug.deployLaunch");
            ILaunchConfigurationWorkingCopy configuration = type.newInstance(null, manager.generateLaunchConfigurationName(resource.get().getName()));
            configuration.setAttribute("org.eclipse.fordiac.ide.deployment.debug.system", resource.get().getFullPath().toString());
            return configuration.launch("org.eclipse.fordiac.ide.deployment.debug.monitor", (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            throw new DeploymentException(e.getMessage(), (Throwable)e);
        }
    }

    protected static IDeviceManagementInteractor waitForConnection(Shell shell, ILaunch launch, Device device) throws ExecutionException {
        IDeviceManagementInteractor[] result = new IDeviceManagementInteractor[1];
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(monitor -> {
                IDeviceManagementInteractor iDeviceManagementInteractor = AbstractDeploymentHandler.waitForConnection(launch, device, monitor);
            });
        }
        catch (InvocationTargetException e) {
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ExecutionException(e.getMessage(), (Throwable)e);
        }
        return result[0];
    }

    protected static IDeviceManagementInteractor waitForConnection(ILaunch launch, Device device, IProgressMonitor monitor) throws InterruptedException {
        while (!monitor.isCanceled() && !launch.isTerminated()) {
            Optional<DeploymentDebugDevice> activeDevice = AbstractDeploymentHandler.findActiveDevice(launch, device);
            if (activeDevice.isPresent()) {
                return activeDevice.get().getDeviceManagementExecutorService();
            }
            Thread.sleep(100L);
        }
        return null;
    }

    protected static Optional<DeploymentDebugDevice> findActiveDevice(Device device) {
        return AbstractDeploymentHandler.getResource(device.getAutomationSystem()).map(DeploymentLaunchConfigurationDelegate::getActiveLaunches).stream().flatMap(Collection::stream).map(launch -> AbstractDeploymentHandler.findActiveDevice(launch, device)).flatMap(Optional::stream).findAny();
    }

    protected static Optional<DeploymentDebugDevice> findActiveDevice(ILaunch launch, Device device) {
        return Stream.of(launch.getDebugTargets()).filter(DeploymentDebugDevice.class::isInstance).map(DeploymentDebugDevice.class::cast).filter(activeDevice -> activeDevice.getName().equals(device.getName()) && activeDevice.isAlive()).findAny();
    }

    protected static Optional<IResource> getResource(AutomationSystem system) {
        return Optional.ofNullable(system).map(LibraryElement::getTypeEntry).map(TypeEntry::getFile);
    }
}

