/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.debug.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.emf.common.ui.URIEditorInput;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.fordiac.ide.debug.EvaluatorDebugVariable;
import org.eclipse.fordiac.ide.debug.preferences.FordiacDebugPreferences;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.typeeditor.TypeEditorInput;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class EvaluatorDebugModelPresentation
implements IDebugModelPresentation {
    public IEditorInput getEditorInput(Object element) {
        if (element instanceof EObject) {
            EObject object = (EObject)element;
            EObject root = EcoreUtil.getRootContainer((EObject)object);
            if (root instanceof FBType) {
                FBType fbType = (FBType)root;
                return new TypeEditorInput((LibraryElement)fbType, fbType.getTypeEntry());
            }
            return this.getEditorInput(((EObject)element).eResource());
        }
        if (element instanceof Resource) {
            Resource resource = (Resource)element;
            URI uri = resource.getURI();
            if (!uri.isPlatformResource()) {
                return new URIEditorInput(uri);
            }
            String path = uri.toPlatformString(true);
            IResource workspaceResource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(path));
            if (workspaceResource instanceof IFile) {
                IFile file = (IFile)workspaceResource;
                return new FileEditorInput(file);
            }
        }
        return null;
    }

    public String getEditorId(IEditorInput input, Object element) {
        URIEditorInput uriEditorInput;
        URI uri;
        IEditorDescriptor editorDescriptor;
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fileEditorInput = (IFileEditorInput)input;
            String fileName = fileEditorInput.getFile().getName();
            IEditorDescriptor editorDescriptor2 = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(fileName);
            if (editorDescriptor2 != null) {
                return editorDescriptor2.getId();
            }
        } else if (input instanceof URIEditorInput && (editorDescriptor = EditUIUtil.getDefaultEditor((URI)(uri = (uriEditorInput = (URIEditorInput)input).getURI()), null)) != null) {
            return editorDescriptor.getId();
        }
        return null;
    }

    public void setAttribute(String attribute, Object value) {
    }

    public Image getImage(Object element) {
        return null;
    }

    public String getText(Object element) {
        if (element instanceof EvaluatorDebugVariable) {
            EvaluatorDebugVariable variable = (EvaluatorDebugVariable)element;
            return EvaluatorDebugModelPresentation.getVariableText(variable);
        }
        return null;
    }

    protected static String getVariableText(EvaluatorDebugVariable variable) {
        StringBuilder buffer = new StringBuilder();
        String valueString = variable.getValue().getValueString();
        int valueMaxDisplayLength = FordiacDebugPreferences.getValueMaxDisplayLength();
        buffer.append(variable.getName());
        buffer.append(" := ");
        if (valueString.length() <= valueMaxDisplayLength) {
            buffer.append(valueString);
        } else {
            buffer.append(valueString.substring(0, valueMaxDisplayLength));
            buffer.append('\u2026');
        }
        return buffer.toString();
    }

    public void computeDetail(IValue value, IValueDetailListener listener) {
        try {
            listener.detailComputed(value, value.getValueString());
        }
        catch (DebugException e) {
            FordiacLogHelper.logWarning((String)"Cannot compute value detail", (Exception)((Object)e));
        }
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }
}

