/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.debug.ui.view.editparts;

import org.eclipse.draw2d.Button;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.fordiac.ide.debug.ui.DebugColorProvider;
import org.eclipse.fordiac.ide.debug.ui.view.editparts.EventValueEditPart;
import org.eclipse.fordiac.ide.debug.ui.view.editparts.FBDebugViewRootEditPart;
import org.eclipse.fordiac.ide.model.eval.fb.FBEvaluatorEventQueue;
import org.eclipse.fordiac.ide.model.eval.fb.FBEvaluatorExternalEventQueue;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.RootEditPart;

public class InputEventValueEditPart
extends EventValueEditPart {
    @Override
    protected IFigure createFigure() {
        Button bt = new Button("");
        bt.setSize(50, -1);
        bt.setOpaque(true);
        bt.setBackgroundColor(DebugColorProvider.getWatchColor());
        bt.setForegroundColor(DebugColorProvider.getWatchTextColor());
        bt.addActionListener(e -> this.triggerEvent());
        return bt;
    }

    @Override
    public Label getLabelFigure() {
        return (Label)this.getFigure().getChildren().get(0);
    }

    private void triggerEvent() {
        FBEvaluatorExternalEventQueue eventQueue = this.getEventQueue();
        if (eventQueue != null) {
            eventQueue.triggerInputEvent(this.getInterfaceElement());
        }
    }

    private FBDebugViewRootEditPart getDebugViewRoot() {
        RootEditPart root = this.getRoot();
        if (root != null) {
            for (EditPart child : root.getChildren()) {
                if (!(child instanceof FBDebugViewRootEditPart)) continue;
                FBDebugViewRootEditPart fbDebugRootEP = (FBDebugViewRootEditPart)child;
                return fbDebugRootEP;
            }
        }
        return null;
    }

    private FBEvaluatorExternalEventQueue getEventQueue() {
        FBEvaluatorEventQueue eventQueue;
        FBDebugViewRootEditPart debugViewRoot = this.getDebugViewRoot();
        if (debugViewRoot != null && (eventQueue = debugViewRoot.getFBEvaluator().getEventQueue()) instanceof FBEvaluatorExternalEventQueue) {
            FBEvaluatorExternalEventQueue fbQueue = (FBEvaluatorExternalEventQueue)eventQueue;
            return fbQueue;
        }
        return null;
    }
}

