/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.debug.ui.view.actions;

import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.fordiac.ide.debug.EvaluatorProcess;
import org.eclipse.fordiac.ide.debug.fb.FBLaunchEventQueue;
import org.eclipse.fordiac.ide.model.eval.fb.FBEvaluator;
import org.eclipse.fordiac.ide.model.eval.fb.FBEvaluatorEventQueue;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.osgi.framework.Bundle;

public final class RepeatEventAction
extends Action {
    private FBLaunchEventQueue eventQueue;

    public RepeatEventAction() {
        super("Repeat event", 2);
        this.setImage();
        this.setEnabled(false);
    }

    public void run() {
        if (this.eventQueue != null) {
            this.eventQueue.setRepeat(this.isChecked());
        }
    }

    public void updateEvaluator(EvaluatorProcess evaluator) {
        FBLaunchEventQueue newEventQueue = RepeatEventAction.getEventQueue(evaluator);
        if (this.eventQueue != newEventQueue) {
            this.eventQueue = newEventQueue;
            if (newEventQueue != null) {
                this.setChecked(newEventQueue.isRepeat());
            }
            this.setEnabled(this.eventQueue != null);
        }
    }

    private static FBLaunchEventQueue getEventQueue(EvaluatorProcess evaluator) {
        FBEvaluatorEventQueue queue;
        if (evaluator != null && (queue = ((FBEvaluator)evaluator.getEvaluator()).getEventQueue()) instanceof FBLaunchEventQueue) {
            return (FBLaunchEventQueue)queue;
        }
        return null;
    }

    private void setImage() {
        Bundle bundle = Platform.getBundle((String)"org.eclipse.debug.ui");
        URL fullPathString = FileLocator.find((Bundle)bundle, (IPath)new Path("icons/full/elcl16/restart_co.png"), null);
        this.setImageDescriptor(ImageDescriptor.createFromURL((URL)fullPathString));
    }
}

