/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.validation;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.fordiac.ide.Messages;
import org.eclipse.fordiac.ide.contractSpec.Age;
import org.eclipse.fordiac.ide.contractSpec.CausalAge;
import org.eclipse.fordiac.ide.contractSpec.CausalFuncDecl;
import org.eclipse.fordiac.ide.contractSpec.CausalReaction;
import org.eclipse.fordiac.ide.contractSpec.ContractSpecPackage;
import org.eclipse.fordiac.ide.contractSpec.EventExpr;
import org.eclipse.fordiac.ide.contractSpec.EventList;
import org.eclipse.fordiac.ide.contractSpec.EventSpec;
import org.eclipse.fordiac.ide.contractSpec.Interval;
import org.eclipse.fordiac.ide.contractSpec.Port;
import org.eclipse.fordiac.ide.contractSpec.Reaction;
import org.eclipse.fordiac.ide.contractSpec.Repetition;
import org.eclipse.fordiac.ide.contractSpec.SingleEvent;
import org.eclipse.fordiac.ide.contractSpec.Value;
import org.eclipse.fordiac.ide.validation.AbstractContractSpecValidator;
import org.eclipse.xtext.validation.Check;

public class ContractSpecValidator
extends AbstractContractSpecValidator {
    private static final int INPUT = 1;
    private static final int OUTPUT = 0;
    public static final String EMPTY_INTERVAL = "emptyInterval";
    public static final String SPECIAL_EMPTY_INTERVAL = "specialEmptyInterval";
    public static final String DEGENERATE_INTERVAL = "degenerateInterval";
    public static final String PORT_NOT_INPUT = "portNotInput";
    public static final String PORT_NOT_OUTPUT = "portNotOutput";

    @Check
    public void checkInterval(Interval interval) {
        boolean isOpen;
        if (interval.getTime() != null) {
            return;
        }
        double begin = ContractSpecValidator.value2Double(interval.getV1());
        double end = ContractSpecValidator.value2Double(interval.getV2());
        boolean bl = isOpen = interval.getB1().equals("]") || interval.getB2().equals("[");
        if (begin > end) {
            this.warning(Messages.EmptyIntervalWarning, (EStructuralFeature)ContractSpecPackage.Literals.INTERVAL__V1, EMPTY_INTERVAL, new String[0]);
        } else if (begin == end && isOpen) {
            this.warning(Messages.EmptyIntervalWarning, (EStructuralFeature)ContractSpecPackage.Literals.INTERVAL__V1, SPECIAL_EMPTY_INTERVAL, new String[0]);
        } else if (begin == end && !isOpen) {
            this.warning(Messages.DegenerateIntervalWarning, (EStructuralFeature)ContractSpecPackage.Literals.INTERVAL__V1, DEGENERATE_INTERVAL, new String[0]);
        }
    }

    @Check
    public void checkSingleEvent(SingleEvent singleEvent) {
        this.checkPortsOfSameType(singleEvent.getEvents(), (EStructuralFeature)ContractSpecPackage.Literals.SINGLE_EVENT__EVENTS);
    }

    @Check
    public void checkRepetition(Repetition repetition) {
        this.checkPortsOfSameType(repetition.getEvents(), (EStructuralFeature)ContractSpecPackage.Literals.REPETITION__EVENTS);
    }

    @Check
    public void checkReaction(Reaction reaction) {
        this.checkPortsOfType(reaction.getTrigger(), 1, (EStructuralFeature)ContractSpecPackage.Literals.REACTION__TRIGGER);
        this.checkPortsOfType(reaction.getReaction(), 0, (EStructuralFeature)ContractSpecPackage.Literals.REACTION__REACTION);
    }

    @Check
    public void checkCausalReaction(CausalReaction causalReaction) {
        this.checkPortsOfType(causalReaction.getE1(), 1, (EStructuralFeature)ContractSpecPackage.Literals.CAUSAL_REACTION__E1);
        this.checkPortsOfType(causalReaction.getE2(), 0, (EStructuralFeature)ContractSpecPackage.Literals.CAUSAL_REACTION__E2);
    }

    @Check
    public void checkAge(Age age) {
        this.checkPortsOfType(age.getTrigger(), 0, (EStructuralFeature)ContractSpecPackage.Literals.AGE__TRIGGER);
        this.checkPortsOfType(age.getReaction(), 1, (EStructuralFeature)ContractSpecPackage.Literals.AGE__REACTION);
    }

    @Check
    public void checkCausalAge(CausalAge causalAge) {
        this.checkPortsOfType(causalAge.getE1(), 0, (EStructuralFeature)ContractSpecPackage.Literals.CAUSAL_AGE__E1);
        this.checkPortsOfType(causalAge.getE2(), 1, (EStructuralFeature)ContractSpecPackage.Literals.CAUSAL_AGE__E2);
    }

    @Check
    public void checkCausalFuncDecl(CausalFuncDecl causalFuncDecl) {
        this.checkPortOfType(causalFuncDecl.getP1(), 1, (EStructuralFeature)ContractSpecPackage.Literals.CAUSAL_FUNC_DECL__P1);
        this.checkPortOfType(causalFuncDecl.getP2(), 0, (EStructuralFeature)ContractSpecPackage.Literals.CAUSAL_FUNC_DECL__P2);
    }

    private void checkPortsOfSameType(EventList list, EStructuralFeature feature) {
        if (list != null && list.getEvents() != null && list.getEvents().size() > 0) {
            int firstType = ((EventSpec)list.getEvents().get(0)).getPort().getIsInput();
            this.checkPortsOfType(list.getEvents(), firstType, feature);
        }
    }

    private void checkPortsOfType(EventExpr expr, int type, EStructuralFeature feature) {
        if (expr.getEvent() != null) {
            this.checkPortOfType(expr.getEvent().getPort(), type, feature);
        } else if (expr.getEvents() != null) {
            this.checkPortsOfType(expr.getEvents().getEvents(), type, feature);
        }
    }

    private void checkPortsOfType(EList<EventSpec> list, int type, EStructuralFeature feature) {
        if (list == null) {
            return;
        }
        for (EventSpec es : list) {
            this.checkPortOfType(es.getPort(), type, feature);
        }
    }

    private void checkPortsOfType(EventSpec es, int type, EStructuralFeature feature) {
        if (es == null) {
            return;
        }
        this.checkPortOfType(es.getPort(), type, feature);
    }

    private void checkPortOfType(Port port, int type, EStructuralFeature feature) {
        if (port != null && port.getIsInput() != type) {
            if (type == 1) {
                String s = String.format(Messages.InputPortExpectedError, port.getName());
                this.error(s, feature, PORT_NOT_INPUT, new String[0]);
            } else {
                String s = String.format(Messages.OutputPortExpectedError, port.getName());
                this.error(s, feature, PORT_NOT_OUTPUT, new String[0]);
            }
        }
    }

    private static double value2Double(Value value) {
        double i = value.getInteger();
        double f = value.getFraction();
        while (f >= 1.0) {
            f /= 10.0;
        }
        return i + f;
    }
}

