/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.editparts;

import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.CompoundBorder;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.fordiac.ide.application.commands.ResizeGroupOrSubappCommand;
import org.eclipse.fordiac.ide.application.editparts.InterfaceEditPartForFBNetwork;
import org.eclipse.fordiac.ide.application.editparts.TargetInterfaceAdapter;
import org.eclipse.fordiac.ide.application.editparts.TargetInterfaceElement;
import org.eclipse.fordiac.ide.application.editparts.TargetPinManager;
import org.eclipse.fordiac.ide.application.figures.UntypedSubappConnectorBorder;
import org.eclipse.fordiac.ide.application.policies.DeleteSubAppInterfaceElementPolicy;
import org.eclipse.fordiac.ide.gef.FixedAnchor;
import org.eclipse.fordiac.ide.gef.annotation.FordiacAnnotationUtil;
import org.eclipse.fordiac.ide.gef.draw2d.ConnectorBorder;
import org.eclipse.fordiac.ide.gef.editparts.InterfaceEditPart;
import org.eclipse.fordiac.ide.gef.editparts.LabelDirectEditManager;
import org.eclipse.fordiac.ide.gef.figures.ToolTipFigure;
import org.eclipse.fordiac.ide.gef.policies.INamedElementRenameEditPolicy;
import org.eclipse.fordiac.ide.model.CoordinateConverter;
import org.eclipse.fordiac.ide.model.commands.change.ChangeNameCommand;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.impl.ErrorMarkerDataTypeImpl;
import org.eclipse.fordiac.ide.model.ui.editors.AdvancedScrollingGraphicalViewer;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.gef.tools.DirectEditManager;

public class UntypedSubAppInterfaceElementEditPart
extends InterfaceEditPartForFBNetwork {
    private final TargetPinManager targetPinManager = new TargetPinManager(this);
    protected TargetInterfaceAdapter targetInteraceAdapter = null;
    private boolean isOverflow = false;

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            if (this.isInExpandedSubapp()) {
                this.targetInteraceAdapter = new TargetInterfaceAdapter(this);
            }
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            if (this.targetInteraceAdapter != null) {
                this.targetInteraceAdapter.deactivate();
            }
            super.deactivate();
        }
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("DirectEditPolicy", (EditPolicy)new INamedElementRenameEditPolicy(){

            protected Command getDirectEditCommand(DirectEditRequest request) {
                GraphicalEditPart graphicalEditPart = this.getHost();
                if (graphicalEditPart instanceof UntypedSubAppInterfaceElementEditPart) {
                    UntypedSubAppInterfaceElementEditPart editPart = (UntypedSubAppInterfaceElementEditPart)graphicalEditPart;
                    ChangeNameCommand changeNameCmd = ChangeNameCommand.forName((INamedElement)UntypedSubAppInterfaceElementEditPart.this.getModel(), (String)((String)request.getCellEditor().getValue()));
                    if (UntypedSubAppInterfaceElementEditPart.this.isInExpandedSubapp()) {
                        return new ResizeGroupOrSubappCommand((GraphicalEditPart)editPart.getParent(), (Command)changeNameCmd);
                    }
                    return changeNameCmd;
                }
                return null;
            }
        });
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new DeleteSubAppInterfaceElementPolicy());
    }

    @Override
    public void performRequest(Request request) {
        if (request.getType() == "direct edit") {
            this.createDirectEditManager().show();
        } else {
            super.performRequest(request);
        }
    }

    private DirectEditManager createDirectEditManager() {
        return new LabelDirectEditManager((GraphicalEditPart)this, this.getNameLabel());
    }

    public int getUncollapsedFigureHeight() {
        List<TargetInterfaceElement> children = this.targetPinManager.getModelChildren(false);
        if (children.isEmpty()) {
            return this.getFigure().getBounds().height;
        }
        return -(children.size() - 1) * 2 + UntypedSubAppInterfaceElementEditPart.getTargetInterfaceLabelHeight() * children.size();
    }

    public int getCollapsedFigureHeight() {
        List<TargetInterfaceElement> children = this.targetPinManager.getModelChildren(true);
        if (children.isEmpty()) {
            return this.getFigure().getBounds().height;
        }
        return -(children.size() - 1) * 2 + UntypedSubAppInterfaceElementEditPart.getTargetInterfaceLabelHeight() * children.size();
    }

    private static int getTargetInterfaceLabelHeight() {
        return 2 * (int)CoordinateConverter.INSTANCE.getLineHeight();
    }

    public Label getNameLabel() {
        return (Label)this.getFigure();
    }

    public boolean isOverflow() {
        return this.isOverflow;
    }

    public void setOverflow(boolean isOverflow) {
        this.isOverflow = isOverflow;
    }

    protected Adapter createContentAdapter() {
        return new UntypedSubappIEAdapter();
    }

    public void refresh() {
        super.refresh();
        this.getNameLabel().setText(this.getLabelText());
        this.refreshToolTip();
    }

    private void refreshToolTip() {
        this.getFigure().setToolTip((IFigure)new ToolTipFigure((INamedElement)this.getModel(), FordiacAnnotationUtil.getAnnotationModel((EditPart)this)));
    }

    protected IFigure createFigure() {
        InterfaceEditPart.InterfaceFigure figure = new InterfaceEditPart.InterfaceFigure(this){

            public String getSubStringText() {
                return this.getChildren().isEmpty() ? super.getSubStringText() : "";
            }

            protected void paintFigure(Graphics graphics) {
                if (!this.getChildren().isEmpty()) {
                    graphics.fillRoundRectangle(this.getBounds(), 8, 8);
                }
                super.paintFigure(graphics);
            }
        };
        figure.setToolTip((IFigure)new ToolTipFigure((INamedElement)this.getModel(), FordiacAnnotationUtil.getAnnotationModel((EditPart)this)));
        figure.setBorder((Border)new UntypedSubappConnectorBorder(this.getModel()));
        return figure;
    }

    protected FixedAnchor createSourceConAnchor() {
        if (this.isInput()) {
            return new FixedAnchor(this.getFigure(), !this.isInput());
        }
        return super.createTargetConAnchor();
    }

    @Override
    protected FixedAnchor createTargetConAnchor() {
        if (!this.isInput()) {
            return new FixedAnchor(this.getFigure(), !this.isInput());
        }
        return super.createTargetConAnchor();
    }

    protected List<? extends Object> getModelChildren() {
        if (this.isInExpandedSubapp()) {
            return this.targetPinManager.getModelChildren(this.isOverflow);
        }
        return super.getModelChildren();
    }

    private boolean isInExpandedSubapp() {
        SubApp subApp;
        BlockFBNetworkElement blockFBNetworkElement = this.getModel().getBlockFBNetworkElement();
        return blockFBNetworkElement instanceof SubApp && (subApp = (SubApp)blockFBNetworkElement).isUnfolded();
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
        IFigure epFigure = this.getFigure();
        if (epFigure.getLayoutManager() == null) {
            GridLayout tbLayout = new GridLayout(1, true);
            tbLayout.marginHeight = 2;
            tbLayout.marginWidth = 0;
            tbLayout.verticalSpacing = 2;
            tbLayout.horizontalSpacing = 0;
            epFigure.setLayoutManager((LayoutManager)tbLayout);
            epFigure.setBackgroundColor(ColorConstants.white);
        }
        IFigure child = ((GraphicalEditPart)childEditPart).getFigure();
        this.getContentPane().add(child, (Object)new GridData(4, 1, true, false), index);
    }

    @Override
    public <T> T getAdapter(Class<T> key) {
        if (key == UntypedSubAppInterfaceElementEditPart.class) {
            return key.cast((Object)this);
        }
        if (key == ErrorMarkerDataTypeImpl.class) {
            IInterfaceElement model = this.getModel();
            ErrorMarkerDataTypeImpl marker = model instanceof VarDeclaration ? (ErrorMarkerDataTypeImpl)model.getType() : null;
            return key.cast(marker);
        }
        return super.getAdapter(key);
    }

    protected int getMaxWidth() {
        if (this.isInExpandedSubapp()) {
            return this.getInterfaceBarMaxWidth();
        }
        return super.getMaxWidth();
    }

    protected int getInterfaceBarMaxWidth() {
        return ((AdvancedScrollingGraphicalViewer)this.getViewer()).getPreferencesCache().getMaxInterfaceBarSize();
    }

    public class UntypedSubappIEAdapter
    extends EContentAdapter {
        public void notifyChanged(Notification notification) {
            if (this.getUntypedSubAppInterfaceElementEditPart().getParent() != null) {
                Object feature = notification.getFeature();
                if (LibraryElementPackage.eINSTANCE.getIInterfaceElement_InputConnections().equals(feature) || LibraryElementPackage.eINSTANCE.getIInterfaceElement_OutputConnections().equals(feature) || LibraryElementPackage.eINSTANCE.getINamedElement_Name().equals(feature) || LibraryElementPackage.eINSTANCE.getINamedElement_Comment().equals(feature)) {
                    UntypedSubAppInterfaceElementEditPart.this.refresh();
                } else if (LibraryElementPackage.eINSTANCE.getIInterfaceElement_Type().equals(feature)) {
                    this.updateConnectorBorderColor();
                    UntypedSubAppInterfaceElementEditPart.this.refreshToolTip();
                }
            }
            super.notifyChanged(notification);
        }

        private void updateConnectorBorderColor() {
            Border border = UntypedSubAppInterfaceElementEditPart.this.getFigure().getBorder();
            if (border instanceof CompoundBorder) {
                CompoundBorder comBorder = (CompoundBorder)border;
                border = comBorder.getOuterBorder();
            }
            if (border instanceof ConnectorBorder) {
                ConnectorBorder conBorder = (ConnectorBorder)border;
                conBorder.updateColor();
                UntypedSubAppInterfaceElementEditPart.this.getFigure().repaint();
            }
        }

        public UntypedSubAppInterfaceElementEditPart getUntypedSubAppInterfaceElementEditPart() {
            return UntypedSubAppInterfaceElementEditPart.this;
        }
    }
}

