/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.formatting2.regionaccess.internal;

import com.google.common.base.Preconditions;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.ITextReplacement;
import org.eclipse.xtext.formatting2.regionaccess.internal.AbstractTextSegment;

public class TextReplacement
extends AbstractTextSegment
implements ITextReplacement {
    private final int length;
    private final int offset;
    private final String replacement;
    private final ITextRegionAccess access;

    public TextReplacement(ITextRegionAccess access, int offset, int length, String text) {
        Preconditions.checkArgument((offset >= 0 ? 1 : 0) != 0, (Object)"offset must be >= 0");
        Preconditions.checkArgument((length >= 0 ? 1 : 0) != 0, (Object)"length must be >= 0");
        this.access = access;
        this.offset = offset;
        this.length = length;
        this.replacement = text;
    }

    public int getLength() {
        return this.length;
    }

    public int getOffset() {
        return this.offset;
    }

    @Override
    public String getReplacementText() {
        return this.replacement;
    }

    @Override
    public ITextRegionAccess getTextRegionAccess() {
        return this.access;
    }

    public String toString() {
        return "[" + this.getText() + "|" + this.getReplacementText() + "]";
    }
}

