/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server.formatting;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.FormattingOptions;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.xtext.formatting.IIndentationInformation;
import org.eclipse.xtext.formatting2.FormatterRequest;
import org.eclipse.xtext.formatting2.IFormatter2;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.ITextReplacement;
import org.eclipse.xtext.formatting2.regionaccess.TextRegionAccessBuilder;
import org.eclipse.xtext.ide.server.Document;
import org.eclipse.xtext.preferences.ITypedPreferenceValues;
import org.eclipse.xtext.preferences.MapBasedPreferenceValues;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.TextRegion;

public class FormattingService {
    @Inject(optional=true)
    private Provider<IFormatter2> formatter2Provider;
    @Inject
    private Provider<FormatterRequest> formatterRequestProvider;
    @Inject
    private TextRegionAccessBuilder regionBuilder;
    @Inject
    private IIndentationInformation indentationInformation;

    public List<? extends TextEdit> format(Document document, XtextResource resource, DocumentFormattingParams params, CancelIndicator cancelIndicator) {
        int offset = 0;
        int length = document.getContents().length();
        if (length == 0 || resource.getContents().isEmpty()) {
            return Collections.emptyList();
        }
        return this.format(resource, document, offset, length, params.getOptions());
    }

    public List<? extends TextEdit> format(Document document, XtextResource resource, DocumentRangeFormattingParams params, CancelIndicator cancelIndicator) {
        ITextRegion region = document.getTextRegion(params.getRange());
        return this.format(resource, document, region.getOffset(), region.getLength(), params.getOptions());
    }

    public List<TextEdit> format(XtextResource resource, Document document, int offset, int length, FormattingOptions options) {
        String indent = this.indentationInformation.getIndentString();
        if (options != null && options.isInsertSpaces()) {
            indent = Strings.padEnd((String)"", (int)options.getTabSize(), (char)' ');
        }
        ArrayList<TextEdit> result = new ArrayList<TextEdit>();
        if (this.formatter2Provider != null) {
            MapBasedPreferenceValues preferences = new MapBasedPreferenceValues();
            preferences.put("indentation", indent);
            List<ITextReplacement> replacements = this.format2(resource, (ITextRegion)new TextRegion(offset, length), (ITypedPreferenceValues)preferences);
            for (ITextReplacement r : replacements) {
                result.add(this.toTextEdit(document, r.getReplacementText(), r.getOffset(), r.getLength()));
            }
        }
        return result;
    }

    protected TextEdit toTextEdit(Document document, String formattedText, int startOffset, int length) {
        TextEdit textEdit = new TextEdit();
        textEdit.setNewText(formattedText);
        textEdit.setRange(new Range(document.getPosition(startOffset), document.getPosition(startOffset + length)));
        return textEdit;
    }

    protected List<ITextReplacement> format2(XtextResource resource, ITextRegion selection, ITypedPreferenceValues preferences) {
        FormatterRequest request = (FormatterRequest)this.formatterRequestProvider.get();
        request.setAllowIdentityEdits(false);
        request.setFormatUndefinedHiddenRegionsOnly(false);
        if (selection != null) {
            request.setRegions(Collections.singletonList(selection));
        }
        if (preferences != null) {
            request.setPreferences(preferences);
        }
        ITextRegionAccess regionAccess = this.regionBuilder.forNodeModel(resource).create();
        request.setTextRegionAccess(regionAccess);
        IFormatter2 formatter2 = (IFormatter2)this.formatter2Provider.get();
        List replacements = formatter2.format(request);
        return replacements;
    }
}

