/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.server;

import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;

public class Document {
    private static final PositionWithDocumentOffset DOCUMENT_START_POSITION = new PositionWithDocumentOffset(new Position(0, 0), 0);
    private final Integer version;
    private final String contents;
    private final boolean printSourceOnError;

    public Document(Integer version, String contents) {
        this(version, contents, true);
    }

    public Document(Integer version, String contents, boolean printSourceOnError) {
        this.version = version;
        this.contents = contents;
        this.printSourceOnError = printSourceOnError;
    }

    public ITextRegion getTextRegion(Range range) {
        PositionWithDocumentOffset start = this.getPostionWithDocumentOffset(range.getStart(), DOCUMENT_START_POSITION);
        PositionWithDocumentOffset end = this.getPostionWithDocumentOffset(range.getEnd(), start);
        return new TextRegion(start.offset, end.offset - start.offset);
    }

    public int getOffSet(Position position) throws IndexOutOfBoundsException {
        return this.getPostionWithDocumentOffset((Position)position, (PositionWithDocumentOffset)Document.DOCUMENT_START_POSITION).offset;
    }

    private PositionWithDocumentOffset getPostionWithDocumentOffset(Position toSearch, PositionWithDocumentOffset start) {
        int l = this.contents.length();
        char NL = '\n';
        int line = start.position.getLine();
        int column = start.position.getCharacter();
        int i = start.offset;
        while (i < l) {
            char ch = this.contents.charAt(i);
            if (toSearch.getLine() == line && toSearch.getCharacter() == column) {
                return new PositionWithDocumentOffset(new Position(line, column), i);
            }
            if (ch == NL) {
                ++line;
                column = 0;
            } else {
                ++column;
            }
            ++i;
        }
        if (toSearch.getLine() == line && toSearch.getCharacter() == column) {
            return new PositionWithDocumentOffset(new Position(line, column), l);
        }
        throw new IndexOutOfBoundsException(toSearch.toString() + this.getSourceOnError());
    }

    public Position getPosition(int offset) throws IndexOutOfBoundsException {
        int l = this.contents.length();
        if (offset < 0 || offset > l) {
            throw new IndexOutOfBoundsException(offset + this.getSourceOnError());
        }
        char NL = '\n';
        int line = 0;
        int column = 0;
        int i = 0;
        while (i < l) {
            char ch = this.contents.charAt(i);
            if (i == offset) {
                return new Position(line, column);
            }
            if (ch == NL) {
                ++line;
                column = 0;
            } else {
                ++column;
            }
            ++i;
        }
        return new Position(line, column);
    }

    public String getLineContent(int lineNumber) throws IndexOutOfBoundsException {
        if (lineNumber < 0) {
            throw new IndexOutOfBoundsException(lineNumber + this.getSourceOnError());
        }
        char NL = '\n';
        char LF = '\r';
        int l = this.contents.length();
        StringBuilder lineContent = new StringBuilder();
        int line = 0;
        int i = 0;
        while (i < l) {
            if (line > lineNumber) {
                return lineContent.toString();
            }
            char ch = this.contents.charAt(i);
            if (line == lineNumber && ch != NL && ch != LF) {
                lineContent.append(ch);
            }
            if (ch == NL) {
                ++line;
            }
            ++i;
        }
        if (line < lineNumber) {
            throw new IndexOutOfBoundsException(lineNumber + this.getSourceOnError());
        }
        return lineContent.toString();
    }

    protected String getSourceOnError() {
        Object source = "";
        if (this.isPrintSourceOnError()) {
            source = " text was : " + this.contents;
        }
        return source;
    }

    public int getLineCount() {
        return this.getPosition(this.contents.length()).getLine() + 1;
    }

    public String getSubstring(Range range) {
        ITextRegion r = this.getTextRegion(range);
        return this.contents.substring(r.getOffset(), r.getEndOffset());
    }

    public Document applyTextDocumentChanges(Iterable<? extends TextDocumentContentChangeEvent> changes) {
        Document currentDocument = this;
        Integer newVersion = null;
        if (currentDocument.version != null) {
            newVersion = currentDocument.version + 1;
        }
        for (TextDocumentContentChangeEvent textDocumentContentChangeEvent : changes) {
            Object newContent;
            if (textDocumentContentChangeEvent.getRange() == null) {
                newContent = textDocumentContentChangeEvent.getText();
            } else {
                ITextRegion r = currentDocument.getTextRegion(textDocumentContentChangeEvent.getRange());
                newContent = currentDocument.contents.substring(0, r.getOffset()) + textDocumentContentChangeEvent.getText() + currentDocument.contents.substring(r.getEndOffset());
            }
            currentDocument = new Document(newVersion, (String)newContent, this.printSourceOnError);
        }
        return currentDocument;
    }

    /*
     * WARNING - void declaration
     */
    public Document applyChanges(Iterable<? extends TextEdit> changes) {
        void var3_7;
        Object newContent = this.contents;
        for (TextEdit textEdit : changes) {
            if (textEdit.getRange() == null) {
                newContent = textEdit.getNewText();
                continue;
            }
            ITextRegion r = this.getTextRegion(textEdit.getRange());
            newContent = ((String)newContent).substring(0, r.getOffset()) + textEdit.getNewText() + ((String)newContent).substring(r.getEndOffset());
        }
        Object var3_5 = null;
        if (this.version != null) {
            Integer n = this.version + 1;
        }
        return new Document((Integer)var3_7, (String)newContent);
    }

    public boolean isPrintSourceOnError() {
        return this.printSourceOnError;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.contents == null ? 0 : this.contents.hashCode());
        result = 31 * result + (this.printSourceOnError ? 1231 : 1237);
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Document other = (Document)obj;
        if (this.contents == null ? other.contents != null : !this.contents.equals(other.contents)) {
            return false;
        }
        if (this.printSourceOnError != other.printSourceOnError) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this);
        b.add("version", (Object)this.version);
        b.add("contents", (Object)this.contents);
        b.add("printSourceOnError", (Object)this.printSourceOnError);
        return b.toString();
    }

    public Integer getVersion() {
        return this.version;
    }

    public String getContents() {
        return this.contents;
    }

    private record PositionWithDocumentOffset(Position position, int offset) {
    }
}

