/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.internal.ISelectionConversionService;
import org.eclipse.ui.statushandlers.StatusManager;

public class IDESelectionConversionService
implements ISelectionConversionService {
    public IStructuredSelection convertToResources(IStructuredSelection originalSelection) {
        ArrayList<IResource> result = new ArrayList<IResource>();
        for (Object currentElement : originalSelection) {
            IResource resource = ResourceUtil.getResource(currentElement);
            if (resource == null) {
                ResourceMapping mapping = ResourceUtil.getResourceMapping(currentElement);
                if (mapping == null) continue;
                ResourceTraversal[] traversals = null;
                try {
                    traversals = mapping.getTraversals(ResourceMappingContext.LOCAL_CONTEXT, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (CoreException e) {
                    StatusManager.getManager().handle(e, "org.eclipse.ui.ide");
                }
                if (traversals == null) continue;
                IResource[] resources = null;
                ResourceTraversal[] resourceTraversalArray = traversals;
                int n = traversals.length;
                int n2 = 0;
                while (n2 < n) {
                    ResourceTraversal traversal = resourceTraversalArray[n2];
                    resources = traversal.getResources();
                    if (resources != null) {
                        result.addAll(Arrays.asList(resources));
                    }
                    ++n2;
                }
                continue;
            }
            result.add(resource);
        }
        if (result.isEmpty()) {
            return StructuredSelection.EMPTY;
        }
        return new StructuredSelection(result.toArray());
    }
}

