/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.session.parser;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.sirius.business.internal.session.parser.SiriusSaxParserNormalAbortException;
import org.eclipse.sirius.tools.api.Messages;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class RepresentationsFileHandler
extends DefaultHandler {
    private boolean dAnalysisModels;
    private boolean dAnalysisReferencedAnalysis;
    private final URI sessionURI;
    private Set<URI> usedModels = new LinkedHashSet<URI>();
    private Set<URI> referencedAnalysis = new LinkedHashSet<URI>();
    private Set<URI> semanticElements = new LinkedHashSet<URI>();
    private Set<String> imageProjectDependencies = new LinkedHashSet<String>();
    private boolean inSemanticElement;
    private boolean inImageAnnotation;
    private boolean inAnnotationDetail;

    public RepresentationsFileHandler(URI sessionURI) {
        this.sessionURI = sessionURI;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals(ViewpointPackage.eINSTANCE.getDAnalysis_Models().getName())) {
            this.dAnalysisModels = true;
            String hrefValue = attributes.getValue("href");
            if (hrefValue != null) {
                this.usedModels.add(URI.createURI((String)hrefValue).resolve(this.sessionURI).trimFragment());
            }
        } else if (qName.equals(ViewpointPackage.eINSTANCE.getDAnalysis_ReferencedAnalysis().getName())) {
            this.dAnalysisReferencedAnalysis = true;
            String hrefValue = attributes.getValue("href");
            if (hrefValue != null) {
                this.referencedAnalysis.add(URI.createURI((String)hrefValue).resolve(this.sessionURI).trimFragment());
            }
        } else if (qName.equals(ViewpointPackage.eINSTANCE.getDAnalysis_EAnnotations().getName())) {
            String hrefValue = attributes.getValue("source");
            if ("ImagesDependencies".equals(hrefValue)) {
                this.inImageAnnotation = true;
            }
        } else if (qName.equals(ViewpointPackage.eINSTANCE.getDAnalysis_SemanticResources().getName())) {
            this.inSemanticElement = true;
        } else if (qName.equals(DescriptionPackage.eINSTANCE.getDAnnotationEntry_Details().getName())) {
            this.inAnnotationDetail = true;
        } else if (qName.equals(ViewpointPackage.eINSTANCE.getDAnalysis_OwnedViews().getName()) && (this.dAnalysisReferencedAnalysis || this.dAnalysisModels)) {
            throw new SiriusSaxParserNormalAbortException(Messages.XMIModelFileHandler_parsingStopedMsg);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String[] detailsSplit;
        String value;
        if (this.inSemanticElement) {
            String value2 = new String(ch, start, length);
            if (value2 != null) {
                this.semanticElements.add(URI.createURI((String)value2).resolve(this.sessionURI).trimFragment());
            }
            this.inSemanticElement = false;
        } else if (this.inAnnotationDetail && this.inImageAnnotation && (value = new String(ch, start, length)) != null && (detailsSplit = value.split(":")).length == 2) {
            this.imageProjectDependencies.add(detailsSplit[1]);
        }
        this.inAnnotationDetail = false;
    }

    @Override
    public void endDocument() throws SAXException {
        throw new SiriusSaxParserNormalAbortException(Messages.XMIModelFileHandler_parsingStopedMsg);
    }

    public Set<URI> getUsedModels() {
        return this.usedModels;
    }

    public Set<URI> getReferencedAnalysis() {
        return this.referencedAnalysis;
    }

    public Set<URI> getSemanticElements() {
        return this.semanticElements;
    }

    public Set<String> getImageProjectDependencies() {
        return this.imageProjectDependencies;
    }
}

