/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.migration;

import java.util.stream.Collectors;
import org.eclipse.sirius.business.internal.migration.AbstractSiriusMigrationService;
import org.osgi.framework.BundleReference;
import org.osgi.framework.Version;

public final class RepresentationsFileMigrationService
extends AbstractSiriusMigrationService {
    public static final Version REPRESENTATION_FILE_MIGRATION_PARTICIPANT_SORT_THRESHOLD = new Version("15.1.0.000000000000");
    private static RepresentationsFileMigrationService instance = new RepresentationsFileMigrationService();

    private RepresentationsFileMigrationService() {
        this.loadContributions();
    }

    @Override
    protected void loadContributions() {
        super.loadContributions();
        this.delegatesParticipants = this.delegatesParticipants.stream().sorted((participant1, participant2) -> {
            ClassLoader classLoader = participant1.getClass().getClassLoader();
            if (classLoader instanceof BundleReference) {
                BundleReference bundleRefPart1 = (BundleReference)classLoader;
                ClassLoader classLoader2 = participant2.getClass().getClassLoader();
                if (classLoader2 instanceof BundleReference) {
                    BundleReference bundleRefPart2 = (BundleReference)classLoader2;
                    return bundleRefPart1.getBundle().getSymbolicName().compareTo(bundleRefPart2.getBundle().getSymbolicName());
                }
            }
            return 0;
        }).collect(Collectors.toList());
        this.delegatesParticipants = this.delegatesParticipants.stream().sorted((participant1, participant2) -> {
            Version migrationVersion1 = participant1.getMigrationVersion();
            Version migrationVersion2 = participant2.getMigrationVersion();
            if (migrationVersion1.compareTo(REPRESENTATION_FILE_MIGRATION_PARTICIPANT_SORT_THRESHOLD) > 0 || migrationVersion2.compareTo(REPRESENTATION_FILE_MIGRATION_PARTICIPANT_SORT_THRESHOLD) > 0) {
                return migrationVersion1.compareTo(migrationVersion2);
            }
            return 0;
        }).collect(Collectors.toList());
    }

    public static RepresentationsFileMigrationService getInstance() {
        return instance;
    }

    @Override
    protected String getKind() {
        return "RepresentationsFile";
    }
}

