/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.dialect;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.sirius.business.api.dialect.description.IInterpretedExpressionQuery;
import org.eclipse.sirius.common.tools.api.interpreter.VariableType;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;

public class CompositeInterpretedExpressionQuery
implements IInterpretedExpressionQuery {
    private final List<IInterpretedExpressionQuery> children = new ArrayList<IInterpretedExpressionQuery>();

    public boolean add(IInterpretedExpressionQuery query) {
        return this.children.add(query);
    }

    public boolean isEmpty() {
        return this.children.isEmpty();
    }

    public IInterpretedExpressionQuery unwrap() {
        if (this.children.size() == 1) {
            return this.children.get(0);
        }
        return this;
    }

    @Override
    public Option<Collection<String>> getTargetDomainClasses() {
        LinkedHashSet targetTypes = new LinkedHashSet();
        for (IInterpretedExpressionQuery query : this.children) {
            Option<Collection<String>> targetDomainClasses = query.getTargetDomainClasses();
            if (!targetDomainClasses.some()) continue;
            targetTypes.addAll((Collection)targetDomainClasses.get());
        }
        Option expressionTarget = targetTypes.isEmpty() ? Options.newNone() : Options.newSome(targetTypes);
        return expressionTarget;
    }

    @Override
    public Collection<EPackage> getPackagesToImport() {
        LinkedHashSet<EPackage> packagesToImport = new LinkedHashSet<EPackage>();
        for (IInterpretedExpressionQuery query : this.children) {
            packagesToImport.addAll(query.getPackagesToImport());
        }
        return packagesToImport;
    }

    @Override
    public Collection<String> getDependencies() {
        LinkedHashSet<String> dependencies = new LinkedHashSet<String>();
        for (IInterpretedExpressionQuery query : this.children) {
            dependencies.addAll(query.getDependencies());
        }
        return dependencies;
    }

    @Override
    public Map<String, VariableType> getAvailableVariables() {
        LinkedHashMap<String, VariableType> availableVariables = new LinkedHashMap<String, VariableType>();
        for (IInterpretedExpressionQuery query : this.children) {
            Map<String, VariableType> innerAvailableVariables = query.getAvailableVariables();
            for (Map.Entry<String, VariableType> entry : innerAvailableVariables.entrySet()) {
                availableVariables.merge(entry.getKey(), entry.getValue(), (existingType, newSimilarType) -> VariableType.fromVariableTypes((VariableType[])new VariableType[]{existingType, newSimilarType}));
            }
        }
        return availableVariables;
    }
}

