/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.provider;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.compare.CompareFactory;
import org.eclipse.emf.compare.ComparePackage;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.provider.EMFCompareEditPlugin;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemColorProvider;
import org.eclipse.emf.edit.provider.IItemFontProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;

public class ComparisonItemProvider
extends ItemProviderAdapter
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource,
IItemColorProvider,
IItemFontProvider {
    public static final String copyright = "Copyright (c) 2012 Obeo.\r\nAll rights reserved. This program and the accompanying materials\r\nare made available under the terms of the Eclipse Public License v1.0\r\nwhich accompanies this distribution, and is available at\r\nhttp://www.eclipse.org/legal/epl-v10.html\r\n\r\nContributors:\r\n    Obeo - initial API and implementation";

    public ComparisonItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addThreeWayPropertyDescriptor(object);
            this.addDiagnosticPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addThreeWayPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Comparison_threeWay_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Comparison_threeWay_feature", "_UI_Comparison_type"), (EStructuralFeature)ComparePackage.Literals.COMPARISON__THREE_WAY, true, false, false, ItemPropertyDescriptor.BOOLEAN_VALUE_IMAGE, null, null));
    }

    protected void addDiagnosticPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Comparison_diagnostic_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Comparison_diagnostic_feature", "_UI_Comparison_type"), (EStructuralFeature)ComparePackage.Literals.COMPARISON__DIAGNOSTIC, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null));
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(ComparePackage.Literals.COMPARISON__MATCHED_RESOURCES);
            this.childrenFeatures.add(ComparePackage.Literals.COMPARISON__MATCHES);
            this.childrenFeatures.add(ComparePackage.Literals.COMPARISON__CONFLICTS);
            this.childrenFeatures.add(ComparePackage.Literals.COMPARISON__EQUIVALENCES);
        }
        return this.childrenFeatures;
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/Comparison"));
    }

    public String getText(Object object) {
        Comparison comparison = (Comparison)object;
        return String.valueOf(this.getString("_UI_Comparison_type")) + " " + comparison.isThreeWay();
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(Comparison.class)) {
            case 4: 
            case 5: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(ComparePackage.Literals.COMPARISON__MATCHED_RESOURCES, CompareFactory.eINSTANCE.createMatchResource()));
        newChildDescriptors.add(this.createChildParameter(ComparePackage.Literals.COMPARISON__MATCHES, CompareFactory.eINSTANCE.createMatch()));
        newChildDescriptors.add(this.createChildParameter(ComparePackage.Literals.COMPARISON__CONFLICTS, CompareFactory.eINSTANCE.createConflict()));
        newChildDescriptors.add(this.createChildParameter(ComparePackage.Literals.COMPARISON__EQUIVALENCES, CompareFactory.eINSTANCE.createEquivalence()));
    }

    public ResourceLocator getResourceLocator() {
        return EMFCompareEditPlugin.INSTANCE;
    }
}

