/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.layer.cell;

import java.io.Serializable;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;
import org.eclipse.nebula.widgets.nattable.layer.cell.AbstractOverrider;
import org.eclipse.nebula.widgets.nattable.layer.cell.CellValueOverrideKey;

public class CellOverrideLabelAccumulator<T>
extends AbstractOverrider {
    private IRowDataProvider<T> dataProvider;

    public CellOverrideLabelAccumulator(IRowDataProvider<T> dataProvider) {
        this.dataProvider = dataProvider;
    }

    @Override
    public void accumulateConfigLabels(LabelStack configLabels, int columnPosition, int rowPosition) {
        List<String> cellLabels = this.getConfigLabels(this.dataProvider.getDataValue(columnPosition, rowPosition), columnPosition);
        if (cellLabels == null) {
            return;
        }
        for (String configLabel : cellLabels) {
            configLabels.addLabel(configLabel);
        }
    }

    protected List<String> getConfigLabels(Object value, int col) {
        CellValueOverrideKey key = new CellValueOverrideKey(value, col);
        return this.getOverrides(key);
    }

    public void registerOverride(Object cellValue, int col, String configLabel) {
        this.registerOverrides((Serializable)new CellValueOverrideKey(cellValue, col), configLabel);
    }
}

