/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.MessageSecurityMode;
import org.eclipse.milo.opcua.stack.core.types.enumerated.SecurityTokenRequestType;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class OpenSecureChannelRequest
extends Structure
implements UaRequestMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=444");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=446");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=445");
    private final RequestHeader requestHeader;
    private final UInteger clientProtocolVersion;
    private final SecurityTokenRequestType requestType;
    private final MessageSecurityMode securityMode;
    private final ByteString clientNonce;
    private final UInteger requestedLifetime;

    public OpenSecureChannelRequest(RequestHeader requestHeader, UInteger clientProtocolVersion, SecurityTokenRequestType requestType, MessageSecurityMode securityMode, ByteString clientNonce, UInteger requestedLifetime) {
        this.requestHeader = requestHeader;
        this.clientProtocolVersion = clientProtocolVersion;
        this.requestType = requestType;
        this.securityMode = securityMode;
        this.clientNonce = clientNonce;
        this.requestedLifetime = requestedLifetime;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public UInteger getClientProtocolVersion() {
        return this.clientProtocolVersion;
    }

    public SecurityTokenRequestType getRequestType() {
        return this.requestType;
    }

    public MessageSecurityMode getSecurityMode() {
        return this.securityMode;
    }

    public ByteString getClientNonce() {
        return this.clientNonce;
    }

    public UInteger getRequestedLifetime() {
        return this.requestedLifetime;
    }

    protected OpenSecureChannelRequest(OpenSecureChannelRequestBuilder<?, ?> b) {
        super(b);
        this.requestHeader = ((OpenSecureChannelRequestBuilder)b).requestHeader;
        this.clientProtocolVersion = ((OpenSecureChannelRequestBuilder)b).clientProtocolVersion;
        this.requestType = ((OpenSecureChannelRequestBuilder)b).requestType;
        this.securityMode = ((OpenSecureChannelRequestBuilder)b).securityMode;
        this.clientNonce = ((OpenSecureChannelRequestBuilder)b).clientNonce;
        this.requestedLifetime = ((OpenSecureChannelRequestBuilder)b).requestedLifetime;
    }

    public static OpenSecureChannelRequestBuilder<?, ?> builder() {
        return new OpenSecureChannelRequestBuilderImpl();
    }

    public OpenSecureChannelRequestBuilder<?, ?> toBuilder() {
        return new OpenSecureChannelRequestBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OpenSecureChannelRequest)) {
            return false;
        }
        OpenSecureChannelRequest other = (OpenSecureChannelRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestHeader this$requestHeader = this.getRequestHeader();
        RequestHeader other$requestHeader = other.getRequestHeader();
        if (this$requestHeader == null ? other$requestHeader != null : !((Object)this$requestHeader).equals(other$requestHeader)) {
            return false;
        }
        UInteger this$clientProtocolVersion = this.getClientProtocolVersion();
        UInteger other$clientProtocolVersion = other.getClientProtocolVersion();
        if (this$clientProtocolVersion == null ? other$clientProtocolVersion != null : !((Object)this$clientProtocolVersion).equals(other$clientProtocolVersion)) {
            return false;
        }
        SecurityTokenRequestType this$requestType = this.getRequestType();
        SecurityTokenRequestType other$requestType = other.getRequestType();
        if (this$requestType == null ? other$requestType != null : !this$requestType.equals(other$requestType)) {
            return false;
        }
        MessageSecurityMode this$securityMode = this.getSecurityMode();
        MessageSecurityMode other$securityMode = other.getSecurityMode();
        if (this$securityMode == null ? other$securityMode != null : !this$securityMode.equals(other$securityMode)) {
            return false;
        }
        ByteString this$clientNonce = this.getClientNonce();
        ByteString other$clientNonce = other.getClientNonce();
        if (this$clientNonce == null ? other$clientNonce != null : !((Object)this$clientNonce).equals(other$clientNonce)) {
            return false;
        }
        UInteger this$requestedLifetime = this.getRequestedLifetime();
        UInteger other$requestedLifetime = other.getRequestedLifetime();
        return !(this$requestedLifetime == null ? other$requestedLifetime != null : !((Object)this$requestedLifetime).equals(other$requestedLifetime));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OpenSecureChannelRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestHeader $requestHeader = this.getRequestHeader();
        result = result * 59 + ($requestHeader == null ? 43 : ((Object)$requestHeader).hashCode());
        UInteger $clientProtocolVersion = this.getClientProtocolVersion();
        result = result * 59 + ($clientProtocolVersion == null ? 43 : ((Object)$clientProtocolVersion).hashCode());
        SecurityTokenRequestType $requestType = this.getRequestType();
        result = result * 59 + ($requestType == null ? 43 : $requestType.hashCode());
        MessageSecurityMode $securityMode = this.getSecurityMode();
        result = result * 59 + ($securityMode == null ? 43 : $securityMode.hashCode());
        ByteString $clientNonce = this.getClientNonce();
        result = result * 59 + ($clientNonce == null ? 43 : ((Object)$clientNonce).hashCode());
        UInteger $requestedLifetime = this.getRequestedLifetime();
        result = result * 59 + ($requestedLifetime == null ? 43 : ((Object)$requestedLifetime).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "OpenSecureChannelRequest(requestHeader=" + this.getRequestHeader() + ", clientProtocolVersion=" + this.getClientProtocolVersion() + ", requestType=" + this.getRequestType() + ", securityMode=" + this.getSecurityMode() + ", clientNonce=" + this.getClientNonce() + ", requestedLifetime=" + this.getRequestedLifetime() + ")";
    }

    private static final class OpenSecureChannelRequestBuilderImpl
    extends OpenSecureChannelRequestBuilder<OpenSecureChannelRequest, OpenSecureChannelRequestBuilderImpl> {
        private OpenSecureChannelRequestBuilderImpl() {
        }

        @Override
        protected OpenSecureChannelRequestBuilderImpl self() {
            return this;
        }

        @Override
        public OpenSecureChannelRequest build() {
            return new OpenSecureChannelRequest(this);
        }
    }

    public static abstract class OpenSecureChannelRequestBuilder<C extends OpenSecureChannelRequest, B extends OpenSecureChannelRequestBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private RequestHeader requestHeader;
        private UInteger clientProtocolVersion;
        private SecurityTokenRequestType requestType;
        private MessageSecurityMode securityMode;
        private ByteString clientNonce;
        private UInteger requestedLifetime;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            OpenSecureChannelRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(OpenSecureChannelRequest instance, OpenSecureChannelRequestBuilder<?, ?> b) {
            b.requestHeader(instance.requestHeader);
            b.clientProtocolVersion(instance.clientProtocolVersion);
            b.requestType(instance.requestType);
            b.securityMode(instance.securityMode);
            b.clientNonce(instance.clientNonce);
            b.requestedLifetime(instance.requestedLifetime);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B requestHeader(RequestHeader requestHeader) {
            this.requestHeader = requestHeader;
            return (B)this.self();
        }

        public B clientProtocolVersion(UInteger clientProtocolVersion) {
            this.clientProtocolVersion = clientProtocolVersion;
            return (B)this.self();
        }

        public B requestType(SecurityTokenRequestType requestType) {
            this.requestType = requestType;
            return (B)this.self();
        }

        public B securityMode(MessageSecurityMode securityMode) {
            this.securityMode = securityMode;
            return (B)this.self();
        }

        public B clientNonce(ByteString clientNonce) {
            this.clientNonce = clientNonce;
            return (B)this.self();
        }

        public B requestedLifetime(UInteger requestedLifetime) {
            this.requestedLifetime = requestedLifetime;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "OpenSecureChannelRequest.OpenSecureChannelRequestBuilder(super=" + super.toString() + ", requestHeader=" + this.requestHeader + ", clientProtocolVersion=" + this.clientProtocolVersion + ", requestType=" + this.requestType + ", securityMode=" + this.securityMode + ", clientNonce=" + this.clientNonce + ", requestedLifetime=" + this.requestedLifetime + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<OpenSecureChannelRequest> {
        @Override
        public Class<OpenSecureChannelRequest> getType() {
            return OpenSecureChannelRequest.class;
        }

        @Override
        public OpenSecureChannelRequest decode(SerializationContext context, UaDecoder decoder) {
            RequestHeader requestHeader = (RequestHeader)decoder.readStruct("RequestHeader", RequestHeader.TYPE_ID);
            UInteger clientProtocolVersion = decoder.readUInt32("ClientProtocolVersion");
            SecurityTokenRequestType requestType = decoder.readEnum("RequestType", SecurityTokenRequestType.class);
            MessageSecurityMode securityMode = decoder.readEnum("SecurityMode", MessageSecurityMode.class);
            ByteString clientNonce = decoder.readByteString("ClientNonce");
            UInteger requestedLifetime = decoder.readUInt32("RequestedLifetime");
            return new OpenSecureChannelRequest(requestHeader, clientProtocolVersion, requestType, securityMode, clientNonce, requestedLifetime);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, OpenSecureChannelRequest value) {
            encoder.writeStruct("RequestHeader", (Object)value.getRequestHeader(), RequestHeader.TYPE_ID);
            encoder.writeUInt32("ClientProtocolVersion", value.getClientProtocolVersion());
            encoder.writeEnum("RequestType", value.getRequestType());
            encoder.writeEnum("SecurityMode", value.getSecurityMode());
            encoder.writeByteString("ClientNonce", value.getClientNonce());
            encoder.writeUInt32("RequestedLifetime", value.getRequestedLifetime());
        }
    }
}

