/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemmanagement.ui.linkhelpers;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.ECC;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.Group;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.Service;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.SystemConfiguration;
import org.eclipse.fordiac.ide.model.ui.actions.OpenListener;
import org.eclipse.fordiac.ide.model.ui.editors.AbstractBreadCrumbEditor;
import org.eclipse.fordiac.ide.model.ui.editors.HandlerHelper;
import org.eclipse.fordiac.ide.systemmanagement.SystemManager;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.ide.ResourceUtil;
import org.eclipse.ui.navigator.ILinkHelper;
import org.eclipse.ui.part.FileEditorInput;

public class SystemExplorerLinkHelper
implements ILinkHelper {
    public IStructuredSelection findSelection(IEditorInput anInput) {
        IWorkbenchPage aPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorPart editor = aPage.findEditor(anInput);
        if (editor != null) {
            if (editor.getAdapter(FBType.class) != null) {
                return SystemExplorerLinkHelper.handleTypeEditor(editor, anInput);
            }
            FBNetwork fbNetwork = (FBNetwork)editor.getAdapter(FBNetwork.class);
            if (fbNetwork != null) {
                return new StructuredSelection((Object)fbNetwork.eContainer());
            }
            FBNetworkElement fbElem = (FBNetworkElement)editor.getAdapter(FBNetworkElement.class);
            if (fbElem != null) {
                return new StructuredSelection((Object)fbElem);
            }
            SystemConfiguration sysConf = (SystemConfiguration)editor.getAdapter(SystemConfiguration.class);
            if (sysConf != null) {
                return new StructuredSelection((Object)sysConf);
            }
        }
        return SystemExplorerLinkHelper.defaultFileSelection(anInput);
    }

    public void activateEditor(IWorkbenchPage aPage, IStructuredSelection aSelection) {
        if (aSelection == null || aSelection.isEmpty()) {
            return;
        }
        Object sel = aSelection.getFirstElement();
        if (sel instanceof EObject) {
            EObject eObj = (EObject)sel;
            SystemExplorerLinkHelper.handleModelElementSelection(aPage, eObj);
        }
        if (sel instanceof IFile) {
            IFile iFile = (IFile)sel;
            SystemExplorerLinkHelper.handleFileSelection(aPage, iFile);
        }
    }

    private static IStructuredSelection handleTypeEditor(IEditorPart editor, IEditorInput anInput) {
        IEditorPart activeEditor = ((FormEditor)editor).getActiveEditor();
        InterfaceList il = (InterfaceList)activeEditor.getAdapter(InterfaceList.class);
        if (il != null) {
            return new StructuredSelection((Object)il);
        }
        Service service = (Service)activeEditor.getAdapter(Service.class);
        if (service != null) {
            return new StructuredSelection((Object)service);
        }
        ECC ecc = (ECC)activeEditor.getAdapter(ECC.class);
        if (ecc != null) {
            return new StructuredSelection((Object)ecc);
        }
        FBNetwork fbNetwork = (FBNetwork)activeEditor.getAdapter(FBNetwork.class);
        if (fbNetwork != null) {
            if (fbNetwork.eContainer() instanceof FBType) {
                return new StructuredSelection((Object)fbNetwork);
            }
            return new StructuredSelection((Object)fbNetwork.eContainer());
        }
        return SystemExplorerLinkHelper.defaultFileSelection(anInput);
    }

    private static void handleFileSelection(IWorkbenchPage aPage, IFile aFile) {
        if (SystemManager.isSystemFile((Object)aFile)) {
            SystemExplorerLinkHelper.handleModelElementSelection(aPage, (EObject)SystemManager.INSTANCE.getSystem(aFile));
        }
    }

    private static void handleModelElementSelection(IWorkbenchPage aPage, EObject sel) {
        IEditorPart editor = SystemExplorerLinkHelper.getRootEditor(aPage, sel);
        if (editor != null) {
            AbstractBreadCrumbEditor breadCrumbEditor = OpenListener.getBreadCrumbEditor((IEditorPart)editor);
            EObject elementToOpen = OpenListener.getElementToOpen((IEditorPart)editor, (EObject)sel);
            if (breadCrumbEditor != null && elementToOpen != null) {
                EObject breadCrumbRef = SystemExplorerLinkHelper.getBreadCrumbRefElement(elementToOpen);
                breadCrumbEditor.getBreadcrumb().setInput((Object)breadCrumbRef);
                if (breadCrumbRef != elementToOpen || elementToOpen instanceof Device) {
                    SubApp subapp;
                    if (elementToOpen instanceof SubApp && (subapp = (SubApp)elementToOpen).isUnfolded()) {
                        HandlerHelper.showExpandedSubapp((SubApp)subapp, (IEditorPart)editor);
                    } else {
                        HandlerHelper.selectElement((Object)elementToOpen, (IEditorPart)editor);
                    }
                }
            }
        }
    }

    private static IEditorPart getRootEditor(IWorkbenchPage aPage, EObject sel) {
        FileEditorInput fileInput;
        IEditorPart editor;
        IFile modelFile = SystemExplorerLinkHelper.getFileForModel(sel);
        if (modelFile != null && (editor = aPage.findEditor((IEditorInput)(fileInput = new FileEditorInput(modelFile)))) != null) {
            aPage.bringToTop((IWorkbenchPart)editor);
            return editor;
        }
        return null;
    }

    private static IFile getFileForModel(EObject sel) {
        EObject root = EcoreUtil.getRootContainer((EObject)sel);
        if (root instanceof LibraryElement) {
            LibraryElement libElem = (LibraryElement)root;
            return libElem.getTypeEntry().getFile();
        }
        return null;
    }

    private static EObject getBreadCrumbRefElement(EObject sel) {
        SubApp subApp;
        FBNetworkElement fbnEl;
        EObject refElement = sel;
        if (sel instanceof FBNetworkElement && (fbnEl = (FBNetworkElement)sel).getType() != null || sel instanceof Group) {
            refElement = sel.eContainer().eContainer();
        }
        while (refElement instanceof SubApp && (subApp = (SubApp)refElement).isUnfolded()) {
            refElement = refElement.eContainer().eContainer();
        }
        return refElement;
    }

    private static IStructuredSelection defaultFileSelection(IEditorInput anInput) {
        IFile file = ResourceUtil.getFile((IEditorInput)anInput);
        if (file != null) {
            return new StructuredSelection((Object)file);
        }
        return StructuredSelection.EMPTY;
    }
}

