/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.AbstractStructTreeNode;
import org.eclipse.fordiac.ide.model.CheckableStructTree;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.TreeViewer;

public class CheckableStructTreeNode
extends AbstractStructTreeNode {
    private boolean isChecked = false;
    private boolean isGrey = false;

    CheckableStructTreeNode(VarDeclaration memberVariable, CheckableStructTreeNode structTreeNode, CheckableStructTree tree) {
        super(memberVariable, structTreeNode, tree);
    }

    CheckableStructTreeNode(CheckableStructTree tree) {
        this.setTree(tree);
    }

    public CheckableStructTree getTree() {
        return (CheckableStructTree)super.getTree();
    }

    @Override
    public CheckableStructTreeNode addChild(EObject memberVariable) {
        if (memberVariable instanceof VarDeclaration) {
            VarDeclaration vardeclaration = (VarDeclaration)memberVariable;
            CheckableStructTreeNode treeNode = new CheckableStructTreeNode(vardeclaration, this, this.getTree());
            this.getChildren().add(treeNode);
            return treeNode;
        }
        return null;
    }

    public void updateNode(boolean check) {
        if (check && this.isGrayChecked()) {
            this.setGrey(false);
        }
        this.check(check);
        this.updateGreyedElements(this);
    }

    void check(boolean isChecked) {
        if (this.getViewer() != null) {
            this.getViewer().setChecked((Object)this, isChecked);
        }
        this.isChecked = isChecked;
    }

    public boolean isChecked() {
        return this.isChecked;
    }

    public boolean isGrayChecked() {
        return this.isGrey && this.isChecked;
    }

    public boolean childIsChecked() {
        return this.childIsChecked(this);
    }

    private void updateGreyedElements(CheckableStructTreeNode node) {
        if (node.isChecked() || node.childIsChecked()) {
            CheckableStructTreeNode.greyParents(node);
        } else {
            this.ungreyParents(node);
        }
    }

    private void ungreyParents(CheckableStructTreeNode node) {
        CheckableStructTreeNode parent = node;
        Object rootNode = node.getTree().getRoot();
        while (parent != rootNode) {
            if (parent.isGrey() && !parent.childIsChecked()) {
                parent.setGrey(false);
                parent.check(false);
                if (this.getViewer() != null) {
                    this.getViewer().setGrayChecked((Object)parent, false);
                }
            }
            parent = (CheckableStructTreeNode)parent.getParent();
        }
    }

    public static void greyParents(CheckableStructTreeNode node) {
        CheckableStructTreeNode parent = node;
        Object rootNode = node.getTree().getRoot();
        while (parent != rootNode) {
            if (!parent.isChecked()) {
                parent.setGrey(true);
                parent.check(true);
                parent.setGrayChecked(true);
            }
            parent = (CheckableStructTreeNode)parent.getParent();
        }
    }

    private void setGrayChecked(boolean b) {
        if (this.getViewer() != null) {
            this.getViewer().setGrayChecked((Object)this, b);
        }
        this.setGrey(b);
        this.check(b);
    }

    protected boolean childIsChecked(AbstractStructTreeNode parent) {
        for (AbstractStructTreeNode node : parent.getChildren()) {
            if (((CheckableStructTreeNode)node).isChecked) {
                return true;
            }
            if (!node.hasChildren()) continue;
            return this.childIsChecked(node);
        }
        return false;
    }

    private static AbstractStructTreeNode find(AbstractStructTreeNode parent, String name) {
        for (AbstractStructTreeNode node : parent.getChildren()) {
            AbstractStructTreeNode find;
            if (node.getPinName().equals(name)) {
                return node;
            }
            if (!node.hasChildren() || (find = CheckableStructTreeNode.find(node, name)) == null) continue;
            return find;
        }
        return null;
    }

    public AbstractStructTreeNode find(String name) {
        return CheckableStructTreeNode.find(this.getTree().getRoot(), name);
    }

    private static void serializeTreeToString(CheckableStructTreeNode parent, StringBuilder stringBuilder) {
        for (AbstractStructTreeNode n : parent.getChildren()) {
            CheckableStructTreeNode node = (CheckableStructTreeNode)n;
            if (node.isChecked && !node.isGrey) {
                stringBuilder.append(node.getPinName());
                stringBuilder.append(",");
            }
            CheckableStructTreeNode.serializeTreeToString(node, stringBuilder);
        }
    }

    public String visibleToString() {
        StringBuilder stringBuilder = new StringBuilder();
        CheckableStructTreeNode.serializeTreeToString(this, stringBuilder);
        if (stringBuilder.length() > 0) {
            return stringBuilder.substring(0, stringBuilder.length() - 1);
        }
        return "";
    }

    public CheckboxTreeViewer getViewer() {
        CheckboxTreeViewer checkboxtreeviewer;
        TreeViewer treeViewer = this.getTree().getViewer();
        return treeViewer instanceof CheckboxTreeViewer ? (checkboxtreeviewer = (CheckboxTreeViewer)treeViewer) : null;
    }

    public boolean isGrey() {
        return this.isGrey;
    }

    private void setGrey(boolean isGrey) {
        if (this.getViewer() != null) {
            this.getViewer().setGrayed((Object)this, isGrey);
        }
        this.isGrey = isGrey;
    }

    public static List<VarDeclaration> getVarDeclarations(List<String> varDeclNames, CheckableStructTreeNode node) {
        ArrayList<VarDeclaration> vars = new ArrayList<VarDeclaration>();
        varDeclNames.forEach(name -> {
            VarDeclaration varDecl;
            CheckableStructTreeNode find = (CheckableStructTreeNode)node.find((String)name);
            VarDeclaration findVarDeclarationInStruct = null;
            if (find != null && (varDecl = (VarDeclaration)EcoreUtil.copy((EObject)(findVarDeclarationInStruct = find.getVariable()))) != null) {
                varDecl.setName((String)name);
                vars.add(varDecl);
            }
        });
        return vars;
    }

    public int hashCode() {
        return this.getPinName() != null ? this.getPinName().hashCode() : super.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CheckableStructTreeNode other = (CheckableStructTreeNode)obj;
        if (this.getPinName() != null && other.getPinName() != null) {
            return this.getPinName().equals(other.getPinName());
        }
        return super.equals(obj);
    }
}

