/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.search.impl;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.fordiac.ide.model.search.ISearchFactory;

public class SearchFactoryRegistryImpl
implements ISearchFactory.Registry {
    private final Map<Class<?>, ISearchFactory> classToFactoryMap = new ConcurrentHashMap();

    @Override
    public ISearchFactory getFactory(Class<?> sourceClass) {
        return this.classToFactoryMap.get(sourceClass);
    }

    @Override
    public ISearchFactory registerFactory(Class<?> sourceClass, ISearchFactory factory) {
        return this.classToFactoryMap.put(sourceClass, factory);
    }

    @Override
    public Map<Class<?>, ISearchFactory> getClassToFactoryMap() {
        return Collections.unmodifiableMap(this.classToFactoryMap);
    }
}

