/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.value;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.fordiac.ide.model.data.UdintType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.eval.value.AnyMagnitudeValue;
import org.eclipse.fordiac.ide.model.eval.value.AnyUnsignedValue;
import org.eclipse.fordiac.ide.model.value.NumericValueConverter;

public final class UDIntValue
implements AnyUnsignedValue {
    public static final UDIntValue DEFAULT = new UDIntValue(0);
    private final int value;

    private UDIntValue(int value) {
        this.value = value;
    }

    public static UDIntValue toUDIntValue(int value) {
        return new UDIntValue(value);
    }

    public static UDIntValue toUDIntValue(Number value) {
        return new UDIntValue(value.intValue());
    }

    public static UDIntValue toUDIntValue(String value) {
        return UDIntValue.toUDIntValue((Number)NumericValueConverter.INSTANCE.toValue(value));
    }

    public static UDIntValue toUDIntValue(AnyMagnitudeValue value) {
        return UDIntValue.toUDIntValue(value.intValue());
    }

    public UdintType getType() {
        return IecTypes.ElementaryTypes.UDINT;
    }

    @Override
    public byte byteValue() {
        return (byte)this.value;
    }

    @Override
    public short shortValue() {
        return (short)this.value;
    }

    @Override
    public int intValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return Integer.toUnsignedLong(this.value);
    }

    @Override
    public double doubleValue() {
        return this.longValue();
    }

    @Override
    public float floatValue() {
        return this.longValue();
    }

    @Override
    public BigInteger bigIntegerValue() {
        return BigInteger.valueOf(this.longValue());
    }

    @Override
    public BigDecimal bigDecimalValue() {
        return BigDecimal.valueOf(this.longValue());
    }

    public int hashCode() {
        return Integer.hashCode(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UDIntValue other = (UDIntValue)obj;
        return this.value == other.value;
    }

    public String toString() {
        return Integer.toUnsignedString(this.value);
    }
}

