/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.interactors;

import java.util.List;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.eclipse.fordiac.ide.deployment.data.ConnectionDeploymentData;
import org.eclipse.fordiac.ide.deployment.data.FBDeploymentData;
import org.eclipse.fordiac.ide.deployment.devResponse.Response;
import org.eclipse.fordiac.ide.deployment.exceptions.DeploymentException;
import org.eclipse.fordiac.ide.deployment.interactors.DeviceManagementExecutorService;
import org.eclipse.fordiac.ide.deployment.interactors.IDeviceManagementInteractor;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;

public interface IDeviceManagementExecutorService
extends IDeviceManagementInteractor,
AutoCloseable {
    public static IDeviceManagementExecutorService of(IDeviceManagementInteractor interactor) {
        if (interactor instanceof IDeviceManagementExecutorService) {
            IDeviceManagementExecutorService concurrent = (IDeviceManagementExecutorService)interactor;
            return concurrent;
        }
        return new DeviceManagementExecutorService(interactor);
    }

    public Future<Void> connectAsync();

    public Future<Void> disconnectAsync();

    public Future<Void> createResourceAsync(Resource var1);

    public Future<Void> writeResourceParameterAsync(Resource var1, String var2, String var3);

    public Future<Void> writeDeviceParameterAsync(Device var1, String var2, String var3);

    public Future<Void> createFBInstanceAsync(FBDeploymentData var1, Resource var2);

    public Future<Void> writeFBParameterAsync(Resource var1, String var2, String var3) throws DeploymentException;

    public Future<Void> writeFBParameterAsync(Resource var1, String var2, FBDeploymentData var3, VarDeclaration var4) throws DeploymentException;

    public Future<Void> createConnectionAsync(Resource var1, ConnectionDeploymentData var2);

    public Future<Void> startFBAsync(Resource var1, FBDeploymentData var2);

    public Future<Void> startResourceAsync(Resource var1);

    public Future<Void> resetResourceAsync(String var1);

    public Future<Void> killResourceAsync(String var1);

    public Future<Void> stopResourceAsync(Resource var1);

    public Future<Void> startDeviceAsync(Device var1);

    public Future<Void> deleteResourceAsync(String var1);

    public Future<Void> deleteFBAsync(Resource var1, FBDeploymentData var2);

    public Future<Void> deleteConnectionAsync(Resource var1, ConnectionDeploymentData var2);

    public Future<Void> killDeviceAsync(Device var1);

    public Future<List<org.eclipse.fordiac.ide.deployment.devResponse.Resource>> queryResourcesAsync();

    public ScheduledFuture<Void> queryResourcesPeriodically(Consumer<List<org.eclipse.fordiac.ide.deployment.devResponse.Resource>> var1, long var2, TimeUnit var4);

    public ScheduledFuture<Void> queryResourcesPeriodically(Consumer<List<org.eclipse.fordiac.ide.deployment.devResponse.Resource>> var1, Consumer<DeploymentException> var2, long var3, TimeUnit var5);

    public Future<Response> readWatchesAsync();

    public ScheduledFuture<Void> readWatchesPeriodically(Consumer<Response> var1, long var2, TimeUnit var4);

    public ScheduledFuture<Void> readWatchesPeriodically(Consumer<Response> var1, Consumer<DeploymentException> var2, long var3, TimeUnit var5);

    public Future<Boolean> addWatchAsync(Resource var1, String var2);

    public Future<Boolean> removeWatchAsync(Resource var1, String var2);

    public Future<Void> triggerEventAsync(Resource var1, String var2);

    public Future<Void> forceValueAsync(Resource var1, String var2, String var3);

    public Future<Void> clearForceAsync(Resource var1, String var2);

    public void shutdown();

    public boolean isShutdown();

    public boolean isTerminated();
}

