/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.debug.fb;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.fordiac.ide.debug.LaunchConfigurationAttributes;
import org.eclipse.fordiac.ide.debug.fb.FBDebugClockMode;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;

public interface FBLaunchConfigurationAttributes
extends LaunchConfigurationAttributes {
    public static final String ID = "org.eclipse.fordiac.ide.debug.fbLaunch";
    public static final String EVENT = "org.eclipse.fordiac.ide.debug.event";
    public static final String REPEAT_EVENT = "org.eclipse.fordiac.ide.debug.repeatEvent";
    public static final String KEEP_RUNNING_WHEN_IDLE = "org.eclipse.fordiac.ide.debug.keepRunningWhenIdle";
    public static final String CLOCK_MODE = "org.eclipse.fordiac.ide.debug.clockMode";
    public static final String CLOCK_INTERVAL = "org.eclipse.fordiac.ide.debug.debugTime";

    public static Event getEvent(ILaunchConfiguration configuration, FBType type, Event defaultEvent) throws CoreException {
        String eventAttribute = configuration.getAttribute(EVENT, "");
        if (eventAttribute != null && !eventAttribute.isEmpty()) {
            Event event = type.getInterfaceList().getEvent(eventAttribute);
            if (event != null && event.isIsInput()) {
                return event;
            }
            return Stream.concat(type.getInterfaceList().getSockets().stream(), type.getInterfaceList().getPlugs().stream()).map(AdapterDeclaration::getAdapterFB).map(FBNetworkElement::getInterface).map(iface -> iface.getEvent(eventAttribute)).filter(Objects::nonNull).filter(Predicate.not(IInterfaceElement::isIsInput)).findAny().orElse(defaultEvent);
        }
        return defaultEvent;
    }

    public static boolean isRepeatEvent(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute(REPEAT_EVENT, false);
    }

    public static boolean isKeepRunningWhenIdle(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute(KEEP_RUNNING_WHEN_IDLE, true);
    }

    public static FBDebugClockMode getClockMode(ILaunchConfiguration configuration) throws CoreException {
        return FBDebugClockMode.fromString(configuration.getAttribute(CLOCK_MODE, null));
    }

    public static boolean isSystem(ILaunchConfiguration configuration) throws CoreException {
        return FBDebugClockMode.SYSTEM.equals((Object)FBLaunchConfigurationAttributes.getClockMode(configuration));
    }

    public static boolean isIncrement(ILaunchConfiguration configuration) throws CoreException {
        return FBDebugClockMode.INCREMENT.equals((Object)FBLaunchConfigurationAttributes.getClockMode(configuration));
    }

    public static boolean isManual(ILaunchConfiguration configuration) throws CoreException {
        return FBDebugClockMode.MANUAL.equals((Object)FBLaunchConfigurationAttributes.getClockMode(configuration));
    }

    public static Duration getClockInterval(ILaunchConfiguration configuration) throws CoreException {
        String debugtime = FBLaunchConfigurationAttributes.getClockIntervalText(configuration);
        if (debugtime != null) {
            try {
                long value = Long.parseLong(debugtime);
                return Duration.of(value, ChronoUnit.MILLIS);
            }
            catch (ArithmeticException | NumberFormatException e) {
                throw new IllegalStateException("Debug clock interval is not accepted!");
            }
        }
        return Duration.ZERO;
    }

    public static String getClockIntervalText(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute(CLOCK_INTERVAL, "0");
    }
}

