import java.awt.*;
import java.awt.event.*;
import java.util.*;

//
// OKDialog - Custom dialog that presents a message and waits for
// you to click on the OK button.
//
// Example use:
//    Dialog ok = new OKDialog(parentFrame, "Click OK to continue");
//    ok.show();  // this way needs a frame
//
//    OKDialog.createOKDialog("Click OK to continue");
//

public class OKDialog extends Dialog implements ActionListener
{
    protected Button okButton;
    protected static Frame createdFrame;

    public OKDialog(Frame parent, String message)
    {
        super(parent, true); // call parent constructor, set modal
        setBackground(Color.lightGray);
//        gb = new GridBagLayout();
//        gc = new GridBagConstraints();
        setLayout(new GridLayout(0,1));
        okButton = new Button("  OK  ");
        okButton.addActionListener(this);
        // take the message string and divide it into lines at the '\n' character
//        gc.gridwidth = GridBagConstraints.REMAINDER;
        StringTokenizer st = new StringTokenizer(message, "\n");
        while(st.hasMoreTokens()) {
            add(new Label(st.nextToken(), Label.CENTER));}
        // now add the button, which must be in a panel so it isn't stretched.
        Panel botPan = new Panel(new FlowLayout());
//        topPan.add(messageLabel);
        botPan.add(okButton);
//        add(topPan);
        add(botPan);

        // make the window compact, to fit its components only and
        // no more
        pack();
    }

    // now do the listening.  I am using the new methods
    public void actionPerformed(ActionEvent event)
    {
        String arg = event.getActionCommand();
        if(event.getSource().equals(okButton))
        {
            setVisible(false);
            if(createdFrame != null)
            {
                createdFrame.setVisible(false);
            }
        }
    }

    // method to create the frame automatically
    public static void createOKDialog(String dialogString)
    {
        if(createdFrame == null)
        {
            createdFrame = new Frame("Dialog");
        }
        OKDialog okDialog = new OKDialog(createdFrame, dialogString);
        createdFrame.setSize(okDialog.getSize().width, okDialog.getSize().height);
        okDialog.setVisible(true);
    }

    // method to create the frame automatically, with the reference to
    // a container passed to act as the parent.  If null is passed, then
    // control is passed to the simple creator
    public static void createOKDialog(String dialogString, Container parent)
    {
        if(!(parent instanceof Container)) createOKDialog(dialogString);
        if(!parent.isVisible()) createOKDialog(dialogString);
        if(createdFrame == null)
        {
            createdFrame = new Frame("Dialog");
        }
        OKDialog okDialog = new OKDialog(createdFrame, dialogString);
        int width = okDialog.getSize().width;
        int height = okDialog.getSize().height;
        createdFrame.setSize(width, height);
        int screenX = 0;
        int screenY = 0;
        if(parent.isVisible()) {
            int parentScreenX = parent.getLocationOnScreen().x;
            int parentScreenY = parent.getLocationOnScreen().y;
            int parentWidth = parent.getBounds().width;
            int parentHeight = parent.getBounds().height;
            screenX = Math.max(0, parentScreenX + parentWidth / 2 - width / 2);
            screenY = Math.max(0, parentScreenY + parentHeight / 2 - height / 2);}
        okDialog.setLocation(screenX, screenY);
        okDialog.setVisible(true);
    }
}
