package PROP::Schema::MySQL;

use strict;
use PROP::Schema;
use base qw/PROP::Schema/;
use PROP::Exception;

sub _query_schema {
    my ($self) = @_;

    my $statement = 'describe ' . $self->get_table_name();
    my $sth = PROP::DBH->get_handle()->prepare($statement);

    unless($sth->execute()) {
	my $msg = "problem querying schema for table '"
	    . $self->get_table_name() . "'";
	die new PROP::Exception($msg);
    }

    my $row;
    while($row = $sth->fetchrow_arrayref()) {
	my $field = new PROP::Schema::Field($row->[0],
					   $row->[3] eq 'PRI' ? 1 : 0);
	$self->_add_field($field);
    }
}

1;

=head1 Author

Andrew Gibbs (awgibbs@awgibbs.com,andrew.gibbs@nist.gov)

=head1 Legalese

This software was developed at the National Institute of Standards and
Technology by employees of the Federal Government in the course of
their official duties. Pursuant to title 17 Section 105 of the United
States Code this software is not subject to copyright protection and
is in the public domain. PROP is an experimental system. NIST
assumes no responsibility whatsoever for its use by other parties, and
makes no guarantees, expressed or implied, about its quality,
reliability, or any other characteristic. We would appreciate
acknowledgement if the software is used.  This software can be
redistributed and/or modified freely provided that any derivative
works bear some notice that they are derived from it, and any modified
versions bear some notice that they have been modified.
