/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.logging.log4j.LogManager;
import org.parosproxy.paros.db.Database;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.db.DatabaseListener;
import org.parosproxy.paros.db.DatabaseServer;
import org.parosproxy.paros.db.DatabaseUnsupportedException;

public abstract class AbstractDatabase
implements Database {
    @Deprecated
    protected final Logger logger = Logger.getLogger(this.getClass());
    private final org.apache.logging.log4j.Logger logger2 = LogManager.getLogger(this.getClass());
    private final List<DatabaseListener> databaseListeners = new ArrayList<DatabaseListener>();

    protected org.apache.logging.log4j.Logger getLogger() {
        return this.logger2;
    }

    protected List<DatabaseListener> getDatabaseListeners() {
        return this.databaseListeners;
    }

    @Override
    public void addDatabaseListener(DatabaseListener listener) {
        this.databaseListeners.add(listener);
    }

    @Override
    public void removeDatabaseListener(DatabaseListener listener) {
        this.notifyClosing(listener);
        this.databaseListeners.remove(listener);
    }

    private void notifyClosing(DatabaseListener listener) {
        try {
            listener.closing(this.getDatabaseServer());
        }
        catch (Exception e) {
            this.getLogger().error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void close(boolean compact) {
        this.close(compact, true);
    }

    @Override
    public void close(boolean compact, boolean cleanup) {
        for (DatabaseListener listener : this.databaseListeners) {
            this.notifyClosing(listener);
        }
        this.removeDatabaseListeners();
    }

    protected void removeDatabaseListeners() {
        this.databaseListeners.clear();
    }

    protected void notifyListenersDatabaseOpen(Collection<DatabaseListener> listeners, DatabaseServer databaseServer) throws DatabaseException {
        for (DatabaseListener databaseListener : listeners) {
            try {
                databaseListener.databaseOpen(databaseServer);
            }
            catch (DatabaseUnsupportedException e) {
                this.getLogger().error(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void notifyListenersDatabaseOpen(DatabaseServer databaseServer) throws DatabaseException {
        this.notifyListenersDatabaseOpen(this.databaseListeners, databaseServer);
    }
}

