/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.servlet;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.MapSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.ContentStreamBase;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.response.BinaryResponseWriter;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.servlet.SolrRequestParsers;

@Deprecated
public class DirectSolrConnection {
    protected final SolrCore core;
    protected final SolrRequestParsers parser;

    public DirectSolrConnection(SolrCore c) {
        this.core = c;
        this.parser = new SolrRequestParsers(c.getSolrConfig());
    }

    public String request(String pathAndParams, String body) throws Exception {
        String path = null;
        MapSolrParams params = null;
        int idx = pathAndParams.indexOf(63);
        if (idx > 0) {
            path = pathAndParams.substring(0, idx);
            params = SolrRequestParsers.parseQueryString(pathAndParams.substring(idx + 1));
        } else {
            path = pathAndParams;
            params = new MapSolrParams(new HashMap());
        }
        return this.request(path, (SolrParams)params, body);
    }

    public String request(String path, SolrParams params, String body) throws Exception {
        SolrRequestHandler handler = this.core.getRequestHandler(path);
        if (handler == null && ("/select".equals(path) || "/select/".equalsIgnoreCase(path))) {
            String qt;
            if (params == null) {
                params = new MapSolrParams(new HashMap());
            }
            if ((handler = this.core.getRequestHandler(qt = params.get("qt"))) == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "unknown handler: " + qt);
            }
        }
        if (handler == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "unknown handler: " + path);
        }
        return this.request(handler, params, body);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String request(SolrRequestHandler handler, SolrParams params, String body) throws Exception {
        if (params == null) {
            params = new MapSolrParams(new HashMap());
        }
        ArrayList<ContentStream> streams = new ArrayList<ContentStream>(1);
        if (body != null && body.length() > 0) {
            streams.add((ContentStream)new ContentStreamBase.StringStream(body));
        }
        SolrQueryRequest req = null;
        try {
            req = this.parser.buildRequestFrom(this.core, params, streams);
            SolrQueryResponse rsp = new SolrQueryResponse();
            SolrRequestInfo.setRequestInfo(new SolrRequestInfo(req, rsp));
            this.core.execute(handler, req, rsp);
            if (rsp.getException() != null) {
                throw rsp.getException();
            }
            QueryResponseWriter responseWriter = this.core.getQueryResponseWriter(req);
            if (responseWriter instanceof BinaryResponseWriter) {
                String string = ((BinaryResponseWriter)responseWriter).serializeResponse(req, rsp);
                return string;
            }
            StringWriter out = new StringWriter();
            responseWriter.write(out, req, rsp);
            String string = out.toString();
            return string;
        }
        finally {
            if (req != null) {
                req.close();
                SolrRequestInfo.clearRequestInfo();
            }
        }
    }

    public void close() {
        this.core.close();
    }
}

