/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.security.resources.api.share;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.BytesRestResponse;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.RestResponse;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.security.dlic.rest.support.Utils;
import org.opensearch.security.resources.ResourcePluginInfo;
import org.opensearch.security.resources.api.share.ShareAction;
import org.opensearch.security.resources.api.share.ShareRequest;
import org.opensearch.security.setting.OpensearchDynamicSetting;
import org.opensearch.transport.client.node.NodeClient;

public class ShareRestAction
extends BaseRestHandler {
    private static final Logger LOGGER = LogManager.getLogger(ShareRestAction.class);
    private final ResourcePluginInfo resourcePluginInfo;
    private final OpensearchDynamicSetting<Boolean> resourceSharingEnabledSetting;
    private final OpensearchDynamicSetting<List<String>> resourceSharingProtectedTypesSetting;

    public ShareRestAction(ResourcePluginInfo resourcePluginInfo, OpensearchDynamicSetting<Boolean> resourceSharingEnabledSetting, OpensearchDynamicSetting<List<String>> resourceSharingProtectedTypesSetting) {
        this.resourcePluginInfo = resourcePluginInfo;
        this.resourceSharingEnabledSetting = resourceSharingEnabledSetting;
        this.resourceSharingProtectedTypesSetting = resourceSharingProtectedTypesSetting;
    }

    public List<RestHandler.Route> routes() {
        return Utils.addRoutesPrefix((List<RestHandler.Route>)ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.PUT, "/share"), (Object)new RestHandler.Route(RestRequest.Method.GET, "/share"), (Object)new RestHandler.Route(RestRequest.Method.PATCH, "/share"), (Object)new RestHandler.Route(RestRequest.Method.POST, "/share")), "/_plugins/_security/api/resource");
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (!this.resourceSharingEnabledSetting.getDynamicSettingValue().booleanValue()) {
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.NOT_IMPLEMENTED, "Feature disabled."));
        }
        String resourceId = request.param("resource_id");
        String resourceType = request.param("resource_type");
        ShareRequest.Builder builder = new ShareRequest.Builder();
        builder.method(request.method());
        if (resourceId != null) {
            builder.resourceId(resourceId);
        }
        builder.resourceType(resourceType);
        if (request.hasContent()) {
            builder.parseContent(request.contentParser(), this.resourcePluginInfo);
        }
        if (builder.resourceId == null || builder.resourceType == null) {
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.BAD_REQUEST, "Resource type and id are both required."));
        }
        String resourceIndex = this.resourcePluginInfo.indexByType(builder.resourceType);
        if (resourceIndex == null) {
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.BAD_REQUEST, "Invalid resource type: " + resourceType));
        }
        builder.resourceIndex(resourceIndex);
        ShareRequest shareRequest = builder.build();
        if (shareRequest.type() != null && !this.resourceSharingProtectedTypesSetting.getDynamicSettingValue().contains(shareRequest.type())) {
            return channel -> channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.BAD_REQUEST, "Resource type " + resourceType + " is not marked as protected."));
        }
        return channel -> client.executeLocally((ActionType)ShareAction.INSTANCE, (ActionRequest)shareRequest, (ActionListener)new RestToXContentListener(channel));
    }
}

