/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.core.InternalApi;
import com.google.api.gax.rpc.ApiExceptionFactory;
import com.google.api.gax.rpc.AutoValue_EndpointContext;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.internal.EnvironmentProvider;
import com.google.api.gax.rpc.mtls.CertificateBasedAccess;
import com.google.auth.Credentials;
import com.google.auth.mtls.CertificateSourceUnavailableException;
import com.google.auth.mtls.DefaultMtlsProviderFactory;
import com.google.auth.mtls.MtlsProvider;
import com.google.auth.oauth2.ComputeEngineCredentials;
import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

@InternalApi
@AutoValue
public abstract class EndpointContext {
    @VisibleForTesting
    static final Logger LOG = Logger.getLogger(EndpointContext.class.getName());
    private static final EndpointContext INSTANCE;
    public static final String GOOGLE_CLOUD_UNIVERSE_DOMAIN = "GOOGLE_CLOUD_UNIVERSE_DOMAIN";
    public static final String INVALID_UNIVERSE_DOMAIN_ERROR_TEMPLATE = "The configured universe domain (%s) does not match the universe domain found in the credentials (%s). If you haven't configured the universe domain explicitly, `googleapis.com` is the default.";
    public static final String UNABLE_TO_RETRIEVE_CREDENTIALS_ERROR_MESSAGE = "Unable to retrieve the Universe Domain from the Credentials.";
    static final String S2A_ENV_ENABLE_USE_S2A = "EXPERIMENTAL_GOOGLE_API_USE_S2A_JAVA";

    public static EndpointContext getDefaultInstance() {
        return INSTANCE;
    }

    @Nullable
    public abstract String serviceName();

    @Nullable
    public abstract String universeDomain();

    @Nullable
    public abstract String clientSettingsEndpoint();

    @Nullable
    public abstract String transportChannelProviderEndpoint();

    abstract boolean useS2A();

    @Nullable
    abstract EnvironmentProvider envProvider();

    @Nullable
    public abstract String mtlsEndpoint();

    public abstract boolean switchToMtlsEndpointAllowed();

    @Nullable
    public abstract MtlsProvider mtlsProvider();

    @Nullable
    abstract CertificateBasedAccess certificateBasedAccess();

    public abstract boolean usingGDCH();

    abstract String resolvedUniverseDomain();

    public abstract String resolvedEndpoint();

    public abstract Builder toBuilder();

    public static Builder newBuilder() {
        return new AutoValue_EndpointContext.Builder().setSwitchToMtlsEndpointAllowed(false).setUsingGDCH(false).setEnvProvider(System::getenv);
    }

    EndpointContext withGDCH() throws IOException {
        return this.toBuilder().setUsingGDCH(true).build();
    }

    public void validateUniverseDomain(Credentials credentials, StatusCode invalidUniverseDomainStatusCode) throws IOException {
        if (this.usingGDCH()) {
            return;
        }
        if (credentials instanceof ComputeEngineCredentials) {
            return;
        }
        String credentialsUniverseDomain = "googleapis.com";
        if (credentials != null) {
            credentialsUniverseDomain = credentials.getUniverseDomain();
        }
        if (!this.resolvedUniverseDomain().equals(credentialsUniverseDomain)) {
            throw ApiExceptionFactory.createException(new Throwable(String.format(INVALID_UNIVERSE_DOMAIN_ERROR_TEMPLATE, this.resolvedUniverseDomain(), credentialsUniverseDomain)), invalidUniverseDomainStatusCode, false);
        }
    }

    static {
        try {
            INSTANCE = EndpointContext.newBuilder().setServiceName("").build();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create a default empty EndpointContext", e);
        }
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setServiceName(String var1);

        public abstract Builder setUniverseDomain(String var1);

        public abstract Builder setClientSettingsEndpoint(String var1);

        public abstract Builder setTransportChannelProviderEndpoint(String var1);

        public abstract Builder setMtlsEndpoint(String var1);

        public abstract Builder setSwitchToMtlsEndpointAllowed(boolean var1);

        public abstract Builder setMtlsProvider(MtlsProvider var1);

        abstract Builder setCertificateBasedAccess(CertificateBasedAccess var1);

        public abstract Builder setUsingGDCH(boolean var1);

        public abstract Builder setResolvedEndpoint(String var1);

        public abstract Builder setResolvedUniverseDomain(String var1);

        abstract Builder setUseS2A(boolean var1);

        abstract Builder setEnvProvider(EnvironmentProvider var1);

        abstract String serviceName();

        abstract String universeDomain();

        abstract String clientSettingsEndpoint();

        abstract String transportChannelProviderEndpoint();

        abstract boolean useS2A();

        abstract EnvironmentProvider envProvider();

        abstract String mtlsEndpoint();

        abstract boolean switchToMtlsEndpointAllowed();

        @Nullable
        abstract MtlsProvider mtlsProvider();

        abstract CertificateBasedAccess certificateBasedAccess();

        abstract boolean usingGDCH();

        abstract String resolvedUniverseDomain();

        abstract EndpointContext autoBuild();

        private String determineUniverseDomain() {
            String universeDomain = this.universeDomain();
            if (this.usingGDCH()) {
                if (universeDomain != null) {
                    throw new IllegalArgumentException("Universe domain configuration is incompatible with GDC-H");
                }
                return "googleapis.com";
            }
            if (universeDomain != null && universeDomain.isEmpty()) {
                throw new IllegalArgumentException("The universe domain value cannot be empty.");
            }
            if (universeDomain == null) {
                universeDomain = System.getenv(EndpointContext.GOOGLE_CLOUD_UNIVERSE_DOMAIN);
            }
            return universeDomain != null ? universeDomain : "googleapis.com";
        }

        private String determineEndpoint() throws IOException {
            String endpoint;
            String customEndpoint;
            CertificateBasedAccess certificateBasedAccess = this.certificateBasedAccess() == null ? CertificateBasedAccess.createWithSystemEnv() : this.certificateBasedAccess();
            MtlsProvider mtlsProvider = this.mtlsProvider();
            if (certificateBasedAccess.useMtlsClientCertificate() && mtlsProvider == null) {
                try {
                    mtlsProvider = DefaultMtlsProviderFactory.create();
                }
                catch (CertificateSourceUnavailableException certificateSourceUnavailableException) {
                }
                catch (IOException e) {
                    LOG.log(Level.WARNING, "DefaultMtlsProviderFactory encountered unexpected IOException: " + e.getMessage());
                    LOG.log(Level.WARNING, "mTLS configuration was detected on the device, but mTLS failed to initialize. Falling back to non-mTLS channel.");
                }
            }
            String string = customEndpoint = this.transportChannelProviderEndpoint() == null ? this.clientSettingsEndpoint() : this.transportChannelProviderEndpoint();
            if (this.usingGDCH()) {
                if (customEndpoint == null) {
                    return this.buildEndpointTemplate(this.serviceName(), this.resolvedUniverseDomain());
                }
                return customEndpoint;
            }
            if (Strings.isNullOrEmpty((String)customEndpoint)) {
                customEndpoint = this.buildEndpointTemplate(this.serviceName(), this.resolvedUniverseDomain());
            }
            if ((endpoint = this.mtlsEndpointResolver(customEndpoint, this.mtlsEndpoint(), this.switchToMtlsEndpointAllowed(), mtlsProvider, certificateBasedAccess)).equals(this.mtlsEndpoint()) && !this.resolvedUniverseDomain().equals("googleapis.com")) {
                throw new IllegalArgumentException("mTLS is not supported in any universe other than googleapis.com");
            }
            return endpoint;
        }

        @VisibleForTesting
        boolean shouldUseS2A() {
            if (Strings.isNullOrEmpty((String)this.mtlsEndpoint())) {
                return false;
            }
            String s2AEnv = this.envProvider().getenv(EndpointContext.S2A_ENV_ENABLE_USE_S2A);
            boolean s2AEnabled = Boolean.parseBoolean(s2AEnv);
            if (!s2AEnabled) {
                return false;
            }
            if (this.usingGDCH()) {
                return false;
            }
            if (!Strings.isNullOrEmpty((String)this.clientSettingsEndpoint()) && !this.buildEndpointTemplate(this.serviceName(), this.resolvedUniverseDomain()).contains(this.clientSettingsEndpoint()) || !Strings.isNullOrEmpty((String)this.transportChannelProviderEndpoint()) && !this.buildEndpointTemplate(this.serviceName(), this.resolvedUniverseDomain()).contains(this.transportChannelProviderEndpoint())) {
                return false;
            }
            return this.mtlsEndpoint().contains("googleapis.com");
        }

        private String buildEndpointTemplate(String serviceName, String resolvedUniverseDomain) {
            return serviceName + "." + resolvedUniverseDomain + ":443";
        }

        @VisibleForTesting
        String mtlsEndpointResolver(String endpoint, String mtlsEndpoint, boolean switchToMtlsEndpointAllowed, MtlsProvider mtlsProvider, CertificateBasedAccess certificateBasedAccess) throws IOException {
            if (switchToMtlsEndpointAllowed && certificateBasedAccess != null && mtlsProvider != null) {
                switch (certificateBasedAccess.getMtlsEndpointUsagePolicy()) {
                    case ALWAYS: {
                        return mtlsEndpoint;
                    }
                    case NEVER: {
                        return endpoint;
                    }
                }
                if (certificateBasedAccess.useMtlsClientCertificate() && mtlsProvider.getKeyStore() != null) {
                    return mtlsEndpoint;
                }
                return endpoint;
            }
            return endpoint;
        }

        public EndpointContext build() throws IOException {
            this.setResolvedUniverseDomain(this.determineUniverseDomain());
            this.setResolvedEndpoint(this.determineEndpoint());
            this.setUseS2A(this.shouldUseS2A());
            return this.autoBuild();
        }
    }
}

