/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import org.bouncycastle.crypto.fips.FipsOperationError;
import org.bouncycastle.crypto.fips.FipsStatus;
import org.bouncycastle.crypto.general.DRBG;

class ContinuousTestingPseudoRNG
implements DRBG {
    private static final int MIN_RESOLUTION = 8;
    private final DRBG drbg;
    private byte[] block;
    private byte[] nextBlock;
    private byte[] initialAdditionalInput;

    ContinuousTestingPseudoRNG(DRBG dRBG, byte[] byArray) {
        this.drbg = dRBG;
        this.block = new byte[0];
        this.nextBlock = new byte[0];
        this.initialAdditionalInput = byArray;
    }

    @Override
    public int getBlockSize() {
        return this.drbg.getBlockSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int generate(byte[] byArray, byte[] byArray2, boolean bl) {
        if (FipsStatus.isErrorStatus()) {
            throw new FipsOperationError(FipsStatus.getStatusMessage());
        }
        ContinuousTestingPseudoRNG continuousTestingPseudoRNG = this;
        synchronized (continuousTestingPseudoRNG) {
            int n;
            if (this.block.length != byArray.length) {
                if (this.block.length < byArray.length) {
                    this.block = new byte[ContinuousTestingPseudoRNG.getTestBlockSize(byArray.length)];
                    this.nextBlock = new byte[ContinuousTestingPseudoRNG.getTestBlockSize(byArray.length)];
                    if (this.initialAdditionalInput != null) {
                        n = this.drbg.generate(this.block, this.initialAdditionalInput, bl);
                        this.initialAdditionalInput = null;
                    } else {
                        n = this.drbg.generate(this.block, null, bl);
                    }
                    if (n < 0) {
                        throw new IllegalStateException("DRBG unable to initialise");
                    }
                } else if (this.block.length != 8) {
                    byte[] byArray3 = new byte[ContinuousTestingPseudoRNG.getTestBlockSize(byArray.length)];
                    System.arraycopy(this.block, this.block.length - byArray3.length, byArray3, 0, byArray3.length);
                    this.block = byArray3;
                    this.nextBlock = new byte[ContinuousTestingPseudoRNG.getTestBlockSize(byArray.length)];
                }
            }
            if ((n = this.drbg.generate(this.nextBlock, byArray2, bl)) < 0) {
                return n;
            }
            if (this.areEqual(this.block, this.nextBlock, 0)) {
                throw new IllegalStateException("Duplicate block detected in DRBG output");
            }
            System.arraycopy(this.nextBlock, 0, byArray, 0, byArray.length);
            System.arraycopy(this.nextBlock, 0, this.block, 0, this.block.length);
        }
        if (FipsStatus.isErrorStatus()) {
            throw new FipsOperationError(FipsStatus.getStatusMessage());
        }
        return byArray.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reseed(byte[] byArray) {
        FipsStatus.isReady();
        ContinuousTestingPseudoRNG continuousTestingPseudoRNG = this;
        synchronized (continuousTestingPseudoRNG) {
            this.drbg.reseed(byArray);
        }
    }

    private boolean areEqual(byte[] byArray, byte[] byArray2, int n) {
        if (n + byArray.length > byArray2.length) {
            return false;
        }
        for (int i = 0; i != byArray.length; ++i) {
            if (byArray[i] == byArray2[n + i]) continue;
            return false;
        }
        return true;
    }

    private static int getTestBlockSize(int n) {
        if (n < 8) {
            return 8;
        }
        return n;
    }
}

