/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.snapshot;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class FileCountSnapshotStats
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, FileCountSnapshotStats> {
    @Nullable
    private final Integer fileCount;
    @Nullable
    private final Long sizeInBytes;
    public static final JsonpDeserializer<FileCountSnapshotStats> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FileCountSnapshotStats::setupFileCountSnapshotStatsDeserializer);

    private FileCountSnapshotStats(Builder builder) {
        this.fileCount = builder.fileCount;
        this.sizeInBytes = builder.sizeInBytes;
    }

    public static FileCountSnapshotStats of(Function<Builder, ObjectBuilder<FileCountSnapshotStats>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Integer fileCount() {
        return this.fileCount;
    }

    @Nullable
    public final Long sizeInBytes() {
        return this.sizeInBytes;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.fileCount != null) {
            generator.writeKey("file_count");
            generator.write(this.fileCount.intValue());
        }
        if (this.sizeInBytes != null) {
            generator.writeKey("size_in_bytes");
            generator.write(this.sizeInBytes.longValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupFileCountSnapshotStatsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::fileCount, JsonpDeserializer.integerDeserializer(), "file_count");
        op.add(Builder::sizeInBytes, JsonpDeserializer.longDeserializer(), "size_in_bytes");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.fileCount);
        result = 31 * result + Objects.hashCode(this.sizeInBytes);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileCountSnapshotStats other = (FileCountSnapshotStats)o;
        return Objects.equals(this.fileCount, other.fileCount) && Objects.equals(this.sizeInBytes, other.sizeInBytes);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, FileCountSnapshotStats> {
        @Nullable
        private Integer fileCount;
        @Nullable
        private Long sizeInBytes;

        public Builder() {
        }

        private Builder(FileCountSnapshotStats o) {
            this.fileCount = o.fileCount;
            this.sizeInBytes = o.sizeInBytes;
        }

        private Builder(Builder o) {
            this.fileCount = o.fileCount;
            this.sizeInBytes = o.sizeInBytes;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder fileCount(@Nullable Integer value) {
            this.fileCount = value;
            return this;
        }

        @Nonnull
        public final Builder sizeInBytes(@Nullable Long value) {
            this.sizeInBytes = value;
            return this;
        }

        @Override
        @Nonnull
        public FileCountSnapshotStats build() {
            this._checkSingleUse();
            return new FileCountSnapshotStats(this);
        }
    }
}

