/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.aggregations.Aggregation;
import org.opensearch.client.opensearch._types.aggregations.AggregationVariant;
import org.opensearch.client.opensearch._types.aggregations.MetricAggregationBase;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class BoxplotAggregation
extends MetricAggregationBase
implements AggregationVariant,
ToCopyableBuilder<Builder, BoxplotAggregation> {
    @Nullable
    private final Double compression;
    public static final JsonpDeserializer<BoxplotAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, BoxplotAggregation::setupBoxplotAggregationDeserializer);

    private BoxplotAggregation(Builder builder) {
        super(builder);
        this.compression = builder.compression;
    }

    public static BoxplotAggregation of(Function<Builder, ObjectBuilder<BoxplotAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.Boxplot;
    }

    @Nullable
    public final Double compression() {
        return this.compression;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.compression != null) {
            generator.writeKey("compression");
            generator.write(this.compression.doubleValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupBoxplotAggregationDeserializer(ObjectDeserializer<Builder> op) {
        BoxplotAggregation.setupMetricAggregationBaseDeserializer(op);
        op.add(Builder::compression, JsonpDeserializer.doubleDeserializer(), "compression");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.compression);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoxplotAggregation other = (BoxplotAggregation)o;
        return Objects.equals(this.compression, other.compression);
    }

    public static class Builder
    extends MetricAggregationBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, BoxplotAggregation> {
        @Nullable
        private Double compression;

        public Builder() {
        }

        private Builder(BoxplotAggregation o) {
            super(o);
            this.compression = o.compression;
        }

        private Builder(Builder o) {
            super(o);
            this.compression = o.compression;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder compression(@Nullable Double value) {
            this.compression = value;
            return this;
        }

        @Override
        @Nonnull
        public BoxplotAggregation build() {
            this._checkSingleUse();
            return new BoxplotAggregation(this);
        }
    }
}

