/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.common.contextmanager;

import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.ml.common.contextmanager.TokenCounter;

public class CharacterBasedTokenCounter
implements TokenCounter {
    @Generated
    private static final Logger log = LogManager.getLogger(CharacterBasedTokenCounter.class);
    private static final double CHARS_PER_TOKEN = 4.0;

    @Override
    public int count(String text) {
        if (text == null || text.isEmpty()) {
            return 0;
        }
        return (int)Math.ceil((double)text.length() / 4.0);
    }

    @Override
    public String truncateFromEnd(String text, int maxTokens) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        int currentTokens = this.count(text);
        if (currentTokens <= maxTokens) {
            return text;
        }
        int maxChars = (int)((double)maxTokens * 4.0);
        if (maxChars >= text.length()) {
            return text;
        }
        return text.substring(0, maxChars);
    }

    @Override
    public String truncateFromBeginning(String text, int maxTokens) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        int currentTokens = this.count(text);
        if (currentTokens <= maxTokens) {
            return text;
        }
        int maxChars = (int)((double)maxTokens * 4.0);
        if (maxChars >= text.length()) {
            return text;
        }
        return text.substring(text.length() - maxChars);
    }

    @Override
    public String truncateMiddle(String text, int maxTokens) {
        if (text == null || text.isEmpty()) {
            return text;
        }
        int currentTokens = this.count(text);
        if (currentTokens <= maxTokens) {
            return text;
        }
        int maxChars = (int)((double)maxTokens * 4.0);
        if (maxChars >= text.length()) {
            return text;
        }
        int halfChars = maxChars / 2;
        String beginning = text.substring(0, halfChars);
        String end = text.substring(text.length() - halfChars);
        return beginning + end;
    }
}

