/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.memoryoptsearch.faiss;

import java.io.IOException;
import lombok.NonNull;
import org.apache.lucene.index.KnnVectorValues;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.hnsw.RandomVectorScorer;
import org.opensearch.knn.jni.SimdVectorComputeService;
import org.opensearch.knn.memoryoptsearch.faiss.MMapVectorValues;

public class NativeRandomVectorScorer
implements RandomVectorScorer {
    @NonNull
    private final KnnVectorValues knnVectorValues;
    private long[] addressAndSize;
    private int maxOrd;
    private int nativeFunctionTypeOrd;

    public NativeRandomVectorScorer(float[] query, KnnVectorValues knnVectorValues, MMapVectorValues mmapVectorValues, SimdVectorComputeService.SimilarityFunctionType similarityFunctionType) {
        this.knnVectorValues = knnVectorValues;
        this.addressAndSize = mmapVectorValues.getAddressAndSize();
        this.maxOrd = knnVectorValues.size();
        this.nativeFunctionTypeOrd = similarityFunctionType.ordinal();
        SimdVectorComputeService.saveSearchContext(query, this.addressAndSize, this.nativeFunctionTypeOrd);
    }

    public void bulkScore(int[] internalVectorIds, float[] scores, int numVectors) {
        SimdVectorComputeService.scoreSimilarityInBulk(internalVectorIds, scores, numVectors);
    }

    public float score(int internalVectorId) throws IOException {
        return SimdVectorComputeService.scoreSimilarity(internalVectorId);
    }

    public int maxOrd() {
        return this.maxOrd;
    }

    public int ordToDoc(int ord) {
        return this.knnVectorValues.ordToDoc(ord);
    }

    public Bits getAcceptOrds(Bits acceptDocs) {
        return this.knnVectorValues.getAcceptOrds(acceptDocs);
    }
}

