/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ec2.model.InstanceAutoRecoveryState;
import software.amazon.awssdk.services.ec2.model.InstanceRebootMigrationState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InstanceMaintenanceOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InstanceMaintenanceOptions> {
    private static final SdkField<String> AUTO_RECOVERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AutoRecovery").getter(InstanceMaintenanceOptions.getter(InstanceMaintenanceOptions::autoRecoveryAsString)).setter(InstanceMaintenanceOptions.setter(Builder::autoRecovery)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoRecovery").unmarshallLocationName("autoRecovery").build()}).build();
    private static final SdkField<String> REBOOT_MIGRATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RebootMigration").getter(InstanceMaintenanceOptions.getter(InstanceMaintenanceOptions::rebootMigrationAsString)).setter(InstanceMaintenanceOptions.setter(Builder::rebootMigration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RebootMigration").unmarshallLocationName("rebootMigration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTO_RECOVERY_FIELD, REBOOT_MIGRATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = InstanceMaintenanceOptions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String autoRecovery;
    private final String rebootMigration;

    private InstanceMaintenanceOptions(BuilderImpl builder) {
        this.autoRecovery = builder.autoRecovery;
        this.rebootMigration = builder.rebootMigration;
    }

    public final InstanceAutoRecoveryState autoRecovery() {
        return InstanceAutoRecoveryState.fromValue(this.autoRecovery);
    }

    public final String autoRecoveryAsString() {
        return this.autoRecovery;
    }

    public final InstanceRebootMigrationState rebootMigration() {
        return InstanceRebootMigrationState.fromValue(this.rebootMigration);
    }

    public final String rebootMigrationAsString() {
        return this.rebootMigration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.autoRecoveryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.rebootMigrationAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InstanceMaintenanceOptions)) {
            return false;
        }
        InstanceMaintenanceOptions other = (InstanceMaintenanceOptions)obj;
        return Objects.equals(this.autoRecoveryAsString(), other.autoRecoveryAsString()) && Objects.equals(this.rebootMigrationAsString(), other.rebootMigrationAsString());
    }

    public final String toString() {
        return ToString.builder((String)"InstanceMaintenanceOptions").add("AutoRecovery", (Object)this.autoRecoveryAsString()).add("RebootMigration", (Object)this.rebootMigrationAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AutoRecovery": {
                return Optional.ofNullable(clazz.cast(this.autoRecoveryAsString()));
            }
            case "RebootMigration": {
                return Optional.ofNullable(clazz.cast(this.rebootMigrationAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("AutoRecovery", AUTO_RECOVERY_FIELD);
        map.put("RebootMigration", REBOOT_MIGRATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<InstanceMaintenanceOptions, T> g) {
        return obj -> g.apply((InstanceMaintenanceOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String autoRecovery;
        private String rebootMigration;

        private BuilderImpl() {
        }

        private BuilderImpl(InstanceMaintenanceOptions model) {
            this.autoRecovery(model.autoRecovery);
            this.rebootMigration(model.rebootMigration);
        }

        public final String getAutoRecovery() {
            return this.autoRecovery;
        }

        public final void setAutoRecovery(String autoRecovery) {
            this.autoRecovery = autoRecovery;
        }

        @Override
        public final Builder autoRecovery(String autoRecovery) {
            this.autoRecovery = autoRecovery;
            return this;
        }

        @Override
        public final Builder autoRecovery(InstanceAutoRecoveryState autoRecovery) {
            this.autoRecovery(autoRecovery == null ? null : autoRecovery.toString());
            return this;
        }

        public final String getRebootMigration() {
            return this.rebootMigration;
        }

        public final void setRebootMigration(String rebootMigration) {
            this.rebootMigration = rebootMigration;
        }

        @Override
        public final Builder rebootMigration(String rebootMigration) {
            this.rebootMigration = rebootMigration;
            return this;
        }

        @Override
        public final Builder rebootMigration(InstanceRebootMigrationState rebootMigration) {
            this.rebootMigration(rebootMigration == null ? null : rebootMigration.toString());
            return this;
        }

        public InstanceMaintenanceOptions build() {
            return new InstanceMaintenanceOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InstanceMaintenanceOptions> {
        public Builder autoRecovery(String var1);

        public Builder autoRecovery(InstanceAutoRecoveryState var1);

        public Builder rebootMigration(String var1);

        public Builder rebootMigration(InstanceRebootMigrationState var1);
    }
}

