"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SecurityPlugin = void 0;
var _operators = require("rxjs/operators");
var _routes = require("./routes");
var _opensearch_security_configuration_plugin = _interopRequireDefault(require("./backend/opensearch_security_configuration_plugin"));
var _opensearch_security_plugin = _interopRequireDefault(require("./backend/opensearch_security_plugin"));
var _security_cookie = require("./session/security_cookie");
var _opensearch_security_client = require("./backend/opensearch_security_client");
var _tenant_index = require("./multitenancy/tenant_index");
var _auth_handler_factory = require("./auth/auth_handler_factory");
var _routes2 = require("./multitenancy/routes");
var _auth_type_routes = require("./routes/auth_type_routes");
var _core = require("../../../src/core/server/saved_objects/migrations/core");
var _saved_objects_wrapper = require("./saved_objects/saved_objects_wrapper");
var _tenant_resolver = require("./multitenancy/tenant_resolver");
var _readonly_service = require("./readonly/readonly_service");
var _resource_access_management_routes = require("./routes/resource_access_management_routes");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == typeof i ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != typeof t || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != typeof i) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
                                                                                                                                                                                                                                                                                                                          *   Copyright OpenSearch Contributors
                                                                                                                                                                                                                                                                                                                          *
                                                                                                                                                                                                                                                                                                                          *   Licensed under the Apache License, Version 2.0 (the "License").
                                                                                                                                                                                                                                                                                                                          *   You may not use this file except in compliance with the License.
                                                                                                                                                                                                                                                                                                                          *   A copy of the License is located at
                                                                                                                                                                                                                                                                                                                          *
                                                                                                                                                                                                                                                                                                                          *       http://www.apache.org/licenses/LICENSE-2.0
                                                                                                                                                                                                                                                                                                                          *
                                                                                                                                                                                                                                                                                                                          *   or in the "license" file accompanying this file. This file is distributed
                                                                                                                                                                                                                                                                                                                          *   on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
                                                                                                                                                                                                                                                                                                                          *   express or implied. See the License for the specific language governing
                                                                                                                                                                                                                                                                                                                          *   permissions and limitations under the License.
                                                                                                                                                                                                                                                                                                                          */
class SecurityPlugin {
  constructor(initializerContext) {
    this.initializerContext = initializerContext;
    _defineProperty(this, "logger", void 0);
    // FIXME: keep an reference of admin client so that it can be used in start(), better to figureout a
    //        decent way to get adminClient in start. (maybe using getStartServices() from setup?)
    // @ts-ignore: property not initialzied in constructor
    _defineProperty(this, "securityClient", void 0);
    _defineProperty(this, "savedObjectClientWrapper", void 0);
    this.logger = initializerContext.logger.get();
    this.savedObjectClientWrapper = new _saved_objects_wrapper.SecuritySavedObjectsClientWrapper();
  }
  async setup(core, {
    dataSource
  }) {
    var _config$multitenancy, _config$multitenancy2;
    this.logger.debug('opendistro_security: Setup');
    const dataSourceEnabled = !!dataSource;
    const config$ = this.initializerContext.config.create();
    const config = await config$.pipe((0, _operators.first)()).toPromise();
    const router = core.http.createRouter();
    const esClient = core.opensearch.legacy.createClient('opendistro_security', {
      plugins: [_opensearch_security_configuration_plugin.default, _opensearch_security_plugin.default]
    });
    if (dataSourceEnabled) {
      dataSource.registerCustomApiSchema(_opensearch_security_configuration_plugin.default);
      dataSource.registerCustomApiSchema(_opensearch_security_plugin.default);
    }
    this.securityClient = new _opensearch_security_client.SecurityClient(esClient);
    const securitySessionStorageFactory = await core.http.createCookieSessionStorageFactory((0, _security_cookie.getSecurityCookieOptions)(config));

    // put logger into route handler context, so that we don't need to pass througth parameters
    core.http.registerRouteHandlerContext('security_plugin', (context, request) => {
      return {
        logger: this.logger,
        esClient
      };
    });

    // setup auth
    const auth = await (0, _auth_handler_factory.getAuthenticationHandler)(config.auth.type, router, config, core, esClient, securitySessionStorageFactory, this.logger);
    core.http.registerAuth(auth.authHandler);

    /* Here we check if multitenancy is enabled to ensure if it is, we insert the tenant info (security_tenant) into the resolved, short URL so the page can correctly load with the right tenant information [Fix for issue 1203](https://github.com/opensearch-project/security-dashboards-plugin/issues/1203 */
    if ((_config$multitenancy = config.multitenancy) !== null && _config$multitenancy !== void 0 && _config$multitenancy.enabled) {
      core.http.registerOnPreResponse((request, preResponse, toolkit) => {
        (0, _tenant_resolver.addTenantParameterToResolvedShortLink)(request);
        return toolkit.next();
      });
    }

    // Register server side APIs
    (0, _routes.defineRoutes)(router, dataSourceEnabled);
    (0, _auth_type_routes.defineAuthTypeRoutes)(router, config);
    (0, _resource_access_management_routes.defineResourceAccessManagementRoutes)(router, dataSourceEnabled);

    // set up multi-tenant routes
    if ((_config$multitenancy2 = config.multitenancy) !== null && _config$multitenancy2 !== void 0 && _config$multitenancy2.enabled) {
      (0, _routes2.setupMultitenantRoutes)(router, securitySessionStorageFactory, this.securityClient);
    }
    if (config.multitenancy.enabled && config.multitenancy.enable_aggregation_view) {
      core.savedObjects.addClientWrapper(2, 'security-saved-object-client-wrapper', this.savedObjectClientWrapper.wrapperFactory);
    }
    const service = new _readonly_service.ReadonlyService(this.logger, this.securityClient, auth, securitySessionStorageFactory, config);
    core.security.registerReadonlyService(service);
    return {
      config$,
      securityConfigClient: esClient
    };
  }

  // TODO: add more logs
  async start(core) {
    var _config$multitenancy3;
    this.logger.debug('opendistro_security: Started');
    const config$ = this.initializerContext.config.create();
    const config = await config$.pipe((0, _operators.first)()).toPromise();
    this.savedObjectClientWrapper.httpStart = core.http;
    this.savedObjectClientWrapper.config = config;
    if ((_config$multitenancy3 = config.multitenancy) !== null && _config$multitenancy3 !== void 0 && _config$multitenancy3.enabled) {
      const globalConfig$ = this.initializerContext.config.legacy.globalConfig$;
      const globalConfig = await globalConfig$.pipe((0, _operators.first)()).toPromise();
      const opensearchDashboardsIndex = globalConfig.opensearchDashboards.index;
      const typeRegistry = core.savedObjects.getTypeRegistry();
      const esClient = core.opensearch.client.asInternalUser;
      const migrationClient = (0, _core.createMigrationOpenSearchClient)(esClient, this.logger);
      (0, _tenant_index.setupIndexTemplate)(esClient, opensearchDashboardsIndex, typeRegistry, this.logger);
      const serializer = core.savedObjects.createSerializer();
      const opensearchDashboardsVersion = this.initializerContext.env.packageInfo.version;
      (0, _tenant_index.migrateTenantIndices)(opensearchDashboardsVersion, migrationClient, this.securityClient, typeRegistry, serializer, this.logger);
    }
    return {
      http: core.http,
      es: core.opensearch.legacy
    };
  }
  stop() {}
}
exports.SecurityPlugin = SecurityPlugin;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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