"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getBarStyleOverrides = exports.renderBars = void 0;
var constants_1 = require("../../../scales/constants");
var canvas_text_bbox_calculator_1 = require("../../../utils/bbox/canvas_text_bbox_calculator");
var common_1 = require("../../../utils/common");
var geometry_1 = require("../../../utils/geometry");
var indexed_geometry_map_1 = require("../utils/indexed_geometry_map");
var specs_1 = require("../utils/specs");
function renderBars(orderIndex, dataSeries, xScale, yScale, panel, color, sharedSeriesStyle, displayValueSettings, styleAccessor, minBarHeight, stackMode, chartRotation) {
    if (minBarHeight === void 0) { minBarHeight = 0; }
    var indexedGeometryMap = new indexed_geometry_map_1.IndexedGeometryMap();
    var barGeometries = [];
    var bboxCalculator = new canvas_text_bbox_calculator_1.CanvasTextBBoxCalculator();
    var padding = 1;
    var _a = sharedSeriesStyle.displayValue, fontSize = _a.fontSize, fontFamily = _a.fontFamily;
    dataSeries.data.forEach(function (datum) {
        var _a, _b, _c;
        var y0 = datum.y0, y1 = datum.y1, initialY1 = datum.initialY1, filled = datum.filled;
        if (y1 === null || initialY1 === null || (filled && filled.y1 !== undefined)) {
            return;
        }
        if (!xScale.isValueInDomain(datum.x)) {
            return;
        }
        var y;
        var y0Scaled;
        if (yScale.type === constants_1.ScaleType.Log) {
            y = y1 === 0 || y1 === null ? yScale.range[0] : yScale.scale(y1);
            if (yScale.isInverted) {
                y0Scaled = y0 === 0 || y0 === null ? yScale.range[1] : yScale.scale(y0);
            }
            else {
                y0Scaled = y0 === 0 || y0 === null ? yScale.range[0] : yScale.scale(y0);
            }
        }
        else {
            y = yScale.scale(y1);
            y0Scaled = y0 === null ? yScale.scale(0) : yScale.scale(y0);
        }
        if (y === null || y0Scaled === null) {
            return;
        }
        var absMinHeight = Math.abs(minBarHeight);
        var height = y0Scaled - y;
        if (absMinHeight !== undefined && height !== 0 && Math.abs(height) < absMinHeight) {
            var heightDelta = absMinHeight - Math.abs(height);
            if (height < 0) {
                height = -absMinHeight;
                y += heightDelta;
            }
            else {
                height = absMinHeight;
                y -= heightDelta;
            }
        }
        var isUpsideDown = height < 0;
        height = Math.abs(height);
        y = isUpsideDown ? y - height : y;
        var xScaled = xScale.scale(datum.x);
        if (xScaled === null) {
            return;
        }
        var seriesIdentifier = {
            key: dataSeries.key,
            specId: dataSeries.specId,
            yAccessor: dataSeries.yAccessor,
            splitAccessors: dataSeries.splitAccessors,
            seriesKeys: dataSeries.seriesKeys,
            smHorizontalAccessorValue: dataSeries.smHorizontalAccessorValue,
            smVerticalAccessorValue: dataSeries.smVerticalAccessorValue,
        };
        var seriesStyle = getBarStyleOverrides(datum, seriesIdentifier, sharedSeriesStyle, styleAccessor);
        var maxPixelWidth = common_1.clamp((_a = seriesStyle.rect.widthRatio) !== null && _a !== void 0 ? _a : 1, 0, 1) * xScale.bandwidth;
        var minPixelWidth = common_1.clamp((_b = seriesStyle.rect.widthPixel) !== null && _b !== void 0 ? _b : 0, 0, maxPixelWidth);
        var width = common_1.clamp((_c = seriesStyle.rect.widthPixel) !== null && _c !== void 0 ? _c : xScale.bandwidth, minPixelWidth, maxPixelWidth);
        var x = xScaled + xScale.bandwidth * orderIndex + xScale.bandwidth / 2 - width / 2;
        var originalY1Value = stackMode === specs_1.StackMode.Percentage ? y1 - (y0 !== null && y0 !== void 0 ? y0 : 0) : initialY1;
        var formattedDisplayValue = displayValueSettings && displayValueSettings.valueFormatter
            ? displayValueSettings.valueFormatter(originalY1Value)
            : undefined;
        var displayValueText = displayValueSettings && displayValueSettings.isAlternatingValueLabel && barGeometries.length % 2
            ? undefined
            : formattedDisplayValue;
        var _d = computeBoxWidth(displayValueText || '', { padding: padding, fontSize: fontSize, fontFamily: fontFamily, bboxCalculator: bboxCalculator, width: width }, displayValueSettings), displayValueWidth = _d.displayValueWidth, fixedFontScale = _d.fixedFontScale;
        var isHorizontalRotation = chartRotation == null || [0, 180].includes(chartRotation);
        var fontSizeFactor = 0.7;
        var referenceWidth = Math.max(isHorizontalRotation ? displayValueWidth : fixedFontScale, 1);
        var textScalingFactor = getFinalFontScalingFactor((width * fontSizeFactor) / referenceWidth, fixedFontScale, fontSize);
        var hideClippedValue = displayValueSettings ? displayValueSettings.hideClippedValue : undefined;
        var bboxWidthFactor = isHorizontalRotation ? textScalingFactor : 1;
        var displayValue = displayValueSettings && displayValueSettings.showValueLabel
            ? {
                fontScale: textScalingFactor,
                fontSize: fixedFontScale,
                text: displayValueText,
                width: bboxWidthFactor * displayValueWidth,
                height: textScalingFactor * fixedFontScale,
                hideClippedValue: hideClippedValue,
                isValueContainedInElement: displayValueSettings.isValueContainedInElement,
            }
            : undefined;
        var barGeometry = {
            displayValue: displayValue,
            x: x,
            y: y,
            transform: {
                x: 0,
                y: 0,
            },
            width: width,
            height: height,
            color: color,
            value: {
                x: datum.x,
                y: originalY1Value,
                mark: null,
                accessor: geometry_1.BandedAccessorType.Y1,
                datum: datum.datum,
            },
            seriesIdentifier: seriesIdentifier,
            seriesStyle: seriesStyle,
            panel: panel,
        };
        indexedGeometryMap.set(barGeometry);
        barGeometries.push(barGeometry);
    });
    bboxCalculator.destroy();
    return {
        barGeometries: barGeometries,
        indexedGeometryMap: indexedGeometryMap,
    };
}
exports.renderBars = renderBars;
function computeBoxWidth(text, _a, displayValueSettings) {
    var padding = _a.padding, fontSize = _a.fontSize, fontFamily = _a.fontFamily, bboxCalculator = _a.bboxCalculator, width = _a.width;
    var fixedFontScale = Math.max(typeof fontSize === 'number' ? fontSize : fontSize.min, 1);
    var computedDisplayValueWidth = bboxCalculator.compute(text || '', padding, fixedFontScale, fontFamily).width;
    if (typeof fontSize !== 'number') {
        return {
            fixedFontScale: fixedFontScale,
            displayValueWidth: computedDisplayValueWidth,
        };
    }
    return {
        fixedFontScale: fixedFontScale,
        displayValueWidth: displayValueSettings && displayValueSettings.isValueContainedInElement ? width : computedDisplayValueWidth,
    };
}
function getFinalFontScalingFactor(scale, fixedFontSize, limits) {
    if (typeof limits === 'number') {
        return 1;
    }
    var finalFontSize = scale * fixedFontSize;
    if (finalFontSize > limits.max) {
        return limits.max / fixedFontSize;
    }
    if (finalFontSize < limits.min) {
        return limits.min / fixedFontSize;
    }
    return scale;
}
function getBarStyleOverrides(datum, seriesIdentifier, seriesStyle, styleAccessor) {
    var styleOverride = styleAccessor && styleAccessor(datum, seriesIdentifier);
    if (!styleOverride) {
        return seriesStyle;
    }
    if (typeof styleOverride === 'string') {
        return __assign(__assign({}, seriesStyle), { rect: __assign(__assign({}, seriesStyle.rect), { fill: styleOverride }) });
    }
    return common_1.mergePartial(seriesStyle, styleOverride, {
        mergeOptionalPartialValues: true,
    });
}
exports.getBarStyleOverrides = getBarStyleOverrides;
//# sourceMappingURL=bars.js.map