/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.rest.action.admin.indices;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.opensearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.opensearch.action.support.IndicesOptions;
import org.opensearch.action.support.clustermanager.AcknowledgedResponse;
import org.opensearch.common.logging.DeprecationLogger;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.core.common.Strings;
import org.opensearch.index.mapper.MapperService;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.transport.client.Requests;
import org.opensearch.transport.client.node.NodeClient;

public class RestPutMappingAction
extends BaseRestHandler {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestPutMappingAction.class);

    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.POST, "/{index}/_mapping"), new RestHandler.Route(RestRequest.Method.PUT, "/{index}/_mapping"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/_mappings"), new RestHandler.Route(RestRequest.Method.PUT, "/{index}/_mappings")));
    }

    @Override
    public String getName() {
        return "put_mapping_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        PutMappingRequest putMappingRequest = Requests.putMappingRequest(Strings.splitStringByCommaToArray((String)request.param("index")));
        Map sourceAsMap = (Map)XContentHelper.convertToMap(request.requiredContent(), false, request.getMediaType()).v2();
        if (MapperService.isMappingSourceTyped("_doc", sourceAsMap)) {
            throw new IllegalArgumentException("Types cannot be provided in put mapping requests");
        }
        putMappingRequest.source(sourceAsMap);
        putMappingRequest.timeout(request.paramAsTime("timeout", putMappingRequest.timeout()));
        putMappingRequest.clusterManagerNodeTimeout(request.paramAsTime("cluster_manager_timeout", putMappingRequest.clusterManagerNodeTimeout()));
        RestPutMappingAction.parseDeprecatedMasterTimeoutParameter(putMappingRequest, request, deprecationLogger, this.getName());
        putMappingRequest.indicesOptions(IndicesOptions.fromRequest(request, putMappingRequest.indicesOptions()));
        putMappingRequest.writeIndexOnly(request.paramAsBoolean("write_index_only", false));
        return channel -> client.admin().indices().putMapping(putMappingRequest, new RestToXContentListener<AcknowledgedResponse>((RestChannel)channel));
    }
}

